<?php

namespace App\Service;

class Mailer
{
    protected $smtpConfig;

    public function __construct($smtpConfig,\Swift_Mailer $mailer)
    {
        $this->smtpConfig = $smtpConfig;
        $this->mailer = $mailer;
    }

    public function sendMail($mailData)
    {
        // connection to swift mail to send emails
        $transport = (new \Swift_SmtpTransport($this->smtpConfig['host'], $this->smtpConfig['port']))
            ->setUsername($this->smtpConfig['user'])
            ->setPassword($this->smtpConfig['password'])
            ->setEncryption($this->smtpConfig['encryption'] ? $this->smtpConfig['encryption'] : null);
        // end connection

        //prepare the mailer and send it
        $mailer = new \Swift_Mailer($transport);


        $message = (new \Swift_Message())
            ->setSubject("[GIHSN] " . $mailData['subject'])
            ->setFrom(array($this->smtpConfig['mailAddress'] => "GIHSN"))
            ->setTo($mailData['to'])
            ->setBody($mailData['message'])
            ->setContentType($mailData['type']);

        // check if we have an attachment to send it in email
        if(isset($mailData['attach']) && $mailData['attach']){
            if (is_array($mailData['attach'])){
                foreach ($mailData['attach'] as $key => $targetPath){
                    $message->attach(\Swift_Attachment::fromPath($targetPath));
                }
            } else {
                $message->attach(\Swift_Attachment::fromPath($mailData['attach']));
            }
        }

        return  $mailer->send($message);
    }

}
