<?php
/**
 * Created by PhpStorm.
 * User: ELLIGY
 * Date: 05/04/2020
 * Time: 21:12
 */

namespace App\Service;

use App\Entity\Main\User;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Mailer\Exception\TransportExceptionInterface;
use Symfony\Component\Templating\EngineInterface;
use Symfony\Component\HttpFoundation\Request;

class EmailsTemplateSender
{
    /**
     * @var EngineInterface
     */
    private $templating;
    protected $mailer;
    private $appParams;
    private $container;

    public function __construct(
        EngineInterface    $templating,
        Mailer             $mailer,
        AppParams          $appParams,
        ContainerInterface $container

    )
    {
        $this->templating = $templating;
        $this->mailer = $mailer;
        $this->appParams = $appParams;
        $this->container = $container;
    }

    /**
     * au moment de création d'un nouveau compte utilisateur alors en envoi un mail avec les détails du compte vers l'utilisateur
     * @param User $recipient
     * @return void
     */
    public function email_registration_temporary_password(User $recipient)
    {
        $mailData = array(
            "to" => $recipient->getEmail(),
            "subject" => "Account creation",
            "message" => $this->templating->render("global/emails/layout.email.twig", [
                "type" => "registration_temporary_password",
                "subject" => "Account creation",
                "recipient" => $recipient
            ]),
            "type" => "text/html"
        );
        $this->mailer->sendMail($mailData);
    }

    // in case of modification of the account we send an email with the details of the account to the user
    public function email_update_acount(User $recipient)
    {
        $mailData = array(
            "to" => $recipient->getEmail(),
            "subject" => "Account modification",
            "message" => $this->templating->render("global/emails/layout.email.twig", [
                "type" => "email_update_acount",
                "subject" => "Account modification",
                "recipient" => $recipient
            ]),
            "type" => "text/html"
        );
        $this->mailer->sendMail($mailData);
    }

    // when the user validates the cgu we send him an email containing the details of the cgu
    public function email_validation_cgu($recipient)
    {
        $mailData = array(
            "to" => $recipient->getEmail(),
            "subject" => "Validation of general terms",
            "message" => $this->templating->render("global/emails/layout.email.twig", [
                "type" => "email_validation_of_cgu",
                "subject" => "Validation of general terms",
                "recipient" => $recipient
            ]),
            "type" => "text/html"
        );
        $this->mailer->sendMail($mailData);
    }

    // after the export data is complete, we send an email to the manager containing the export result as a file for download.
    public function email_send_export($filecsv, $email, $fullNameUser)
    {

        $url = $this->container->getParameter('URL_FILE');
//        file_put_contents("/var/www/clients/client18/web33/web/public/uploads/export/acces.txt", date('Y-m-d H:i:s'));
//        file_put_contents("/var/www/clients/client18/web33/web/public/uploads/export/var.txt", $email. ' '.$filecsv);
//        try {
//            file_put_contents("/var/www/clients/client18/web33/web/public/uploads/export/email.txt",
//                $this->templating->render("global/emails/layout.email.twig", [
//                    "type" => "export_email",
//                    "subject" => "Export data",
//                    "recipient" => $email,
//                    "filecsv" => $filecsv,
//                    "url" => $url
//                ]));
//        }catch(\Exception $e){
//            file_put_contents("/var/www/clients/client18/web33/web/public/uploads/export/error_rendingtwig.txt", '');
//        }
        try {
            $mailData = array(
                "to" => $email,
                "subject" => "Export data",
                "message" => $this->templating->render("global/emails/layout.email.twig", [
                    "type" => "export_email",
                    "subject" => "Export data",
                    "recipient" => $email,
                    "recipient_name" => $fullNameUser,
                    "filecsv" => $filecsv,
                    "url" => $url
                ]),
                "type" => "text/html"
            );
            $this->mailer->sendMail($mailData);
        } catch (TransportExceptionInterface $e) {
            file_put_contents("/var/www/clients/client18/web33/web/public/uploads/export/error.txt", $e->getDebug());
        }
    }


    public function email_request_data($user, $managers, $zones, $seasons, $age, $checked)
    {
        // 01- envoi de mail vers l'utilisateur pour lui dire :
//        Hello,
//
//        Your data request has successfully been sent to our team.
//            We will review your query, and someone from our team will get back to you shortly with the requested data.
//        For any additional questions, please contact us through : contact@gihsn.org
//        We thank you for your confidence.
//
//         Best regards,
//         The GIHSN team
        try {
            $mailData = array(
                "to" => $user->getEmail(),
                "subject" => "Request data",
                "message" => $this->templating->render("global/emails/layout.email.twig", [
                    "type" => "to_user_after_send_request",
                    "subject" => "Request data",
                    "recipient" => $user->getEmail(),
                    "user" => $user,
                    "zone" => $zones,
                    "season" => $seasons,
                    "age" => $age,
                    "all_checked" => $checked
                ]),
                "type" => "text/html"
            );
            $this->mailer->sendMail($mailData);
        } catch (\Exception $e) {
            //dd($e->getMessage());
        }


        // 02- envoi de mail de notification à tous les managers de l'application pour notifier de la nouvelle demande de l'utilisatur
        foreach ($managers as $manager) {
            $mailData = array(
                "to" => $manager->getEmail(),
                "subject" => "Request data",
                "message" => $this->templating->render("global/emails/layout.email.twig", [
                    "type" => "request_data",
                    "subject" => "Request data",
                    "recipient" => $manager->getEmail(),
                    "recipient_name" => $manager->getFullName(),
                    "user" => $user,
                    "zone" => $zones,
                    "season" => $seasons,
                    "age" => $age,
                    "all_checked" => $checked
                ]),
                "type" => "text/html"
            );
            $this->mailer->sendMail($mailData);
        }

    }

    // once the PHILIPPE data import is complete, we send an email to the 'email_admin'  if this import contains errors.
    public function email_after_import_data($data, $email, $file)
    {
        try {
            $mailData = array(
                "to" => $email,
                "subject" => "Import data from DB Phillippe",
                "message" => $this->templating->render("global/emails/layout.email.twig", [
                    "type" => "email_after_import_data",
                    "subject" => "Import data from DB Phillippe",
                    "recipient" => $email,
                    "file" => $file,
                    "data" => $data
                ]),
                "type" => "text/html"
            );
            $this->mailer->sendMail($mailData);
        } catch (\Exception $e) {
            //   dd($e->getMessage());
        }
    }

    // after the export data is complete, we send an email to the manager containing the export result as a file for download.
    public function email_send_completeness_database($filecsv, $email, $fullNameUser)
    {

        $url = $this->container->getParameter('URL_FILE');
        try {
            $mailData = array(
                "to" => $email,
                "subject" => "Completeness Database",
                "message" => $this->templating->render("global/emails/layout.email.twig", [
                    "type" => "email_send_completeness_database",
                    "subject" => "Completeness Database",
                    "recipient" => $email,
                    "recipient_name" => $fullNameUser,
                    "filecsv" => $filecsv,
                    "url" => $url
                ]),
                "type" => "text/html"
            );
            $this->mailer->sendMail($mailData);
        } catch (TransportExceptionInterface $e) {
            file_put_contents("/var/www/clients/client18/web33/web/public/uploads/export/error.txt", $e->getDebug());
        }
    }

    public function email_send_dashboard_user_export($email, $fullNameUser, $url)
    {
        try {
            $mailData = array(
                "to" => $email,
                "subject" => "Export Dataset",
                "message" => $this->templating->render("global/emails/layout.email.twig", [
                    "type" => "email_send_dashboard_user_export",
                    "subject" => "Export Dataset",
                    "recipient" => $email,
                    "recipient_name" => $fullNameUser,
                    "url" => $url
                ]),
                "type" => "text/html"
            );
            $this->mailer->sendMail($mailData);
        } catch (TransportExceptionInterface $e) {
            file_put_contents("/var/www/clients/client18/web33/web/public/uploads/export/error.txt", $e->getDebug());
        }
    }

}
