<?php

namespace App\Service;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Yaml\Yaml;

class AppParams
{
    protected $em;
    protected $targetDirectory;

    public function __construct(EntityManagerInterface $entityManager, $targetDirectory)
    {
        $this->em = $entityManager;
        $this->targetDirectory = $targetDirectory;
    }

    protected function getTargetDirectory()
    {
        return $this->targetDirectory;
    }

    public function getAllParams()
    {
        $appParams = Yaml::parseFile($this->getTargetDirectory());
        return $appParams;
    }

    public function setParamByKey(string $key, string $value)
    {
        $appParams = Yaml::parseFile($this->getTargetDirectory());
        $appParams[$key] = $value;
        $appParamsYML = Yaml::dump($appParams);
        file_put_contents($this->getTargetDirectory(), $appParamsYML);
    }

    public function getParamByKey(string $key)
    {
        $gihsnParams = Yaml::parseFile($this->getTargetDirectory());
        return $gihsnParams[$key];
    }
}