<?php

namespace App\Repository\Main;

use App\Entity\Main\Site;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method Site|null find($id, $lockMode = null, $lockVersion = null)
 * @method Site|null findOneBy(array $criteria, array $orderBy = null)
 * @method Site[]    findAll()
 * @method Site[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class SiteRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Site::class);
    }

    /**
     * Desacription : get list of zone for the filter
     * @return Site[]
     */
    public function zoneList($ids)
    {
        return $this->createQueryBuilder('site')
            ->select("site.zone")
            ->Where("site.id IN (:ids)")
            ->setParameter('ids', $ids)
            ->getQuery()
            ->getResult()
            ;
    }

    // get all sites
    public function findList()
    {
        $qb = $this->createQueryBuilder('s')
            ->select("s")
            ->innerJoin('s.data', 'd')
            ->where('s.id = d.site')
            ->groupBy('s.id');

        return $qb ->getQuery()->getResult();
    }
}
