<?php

namespace App\Repository\Main;

use App\Entity\Main\Data;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method Data|null find($id, $lockMode = null, $lockVersion = null)
 * @method Data|null findOneBy(array $criteria, array $orderBy = null)
 * @method Data[]    findAll()
 * @method Data[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class DataRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Data::class);
    }

    public function dataFilter($filters = null)
    {
        if ($filters !== null) {

            $qb = $this->createQueryBuilder('data')
                ->select("count(data.id) as nbr_patient, data.season, data.age, site.id, site.zone")
                ->leftJoin('data.site', 'site', 'with', 'data.site = site.id');

            if (array_key_exists("season", $filters) && $filters['season'] != "") {
                $seasons = explode(',', $filters['season']);
                $qb->andWhere('data.season IN (:seasons)')
                    ->setParameter('seasons', $seasons);
            }

            if (array_key_exists("zone", $filters) && $filters['zone'] != "") {
                $zone = explode(',', $filters['zone']);
                in_array(30, $zone) ? array_push($zone, 4) : null;
                in_array(16, $zone) ? array_push($zone, 26) : null;
                $qb->andWhere("site.id IN (:ids)")
                    ->setParameter('ids', $zone);
            }
            if (array_key_exists("age", $filters) && $filters['age'] != "") {
                $age = explode(',', $filters['age']);

                $qb->andWhere("data.age between :min and :max")
                    ->setParameter('min', (int)$age[0])
                    ->setParameter('max', (int)$age[1]);
            }
            $qb->groupBy('data.season')
                ->addGroupBy('site.zone');

            return $qb->getQuery()->getResult();

        }
    }

    /**
     * get only the 2 season '20_21','21_22' for page Questionnaires and protocols
     * @return Data[] Returns an array of Data objects
     */
    public function seasonListProtocol()
    {

        return $this->createQueryBuilder('data')
            ->select("DISTINCT(data.season) as season")
            ->where(" data.season IS NOT NULL ")
            ->andWhere(" data.season IN ('20_21','21_22','22_23','23_24') ")
            ->orderBy("data.season")
            ->getQuery()
            ->getResult();
    }

    /**
     * get list of season for the filter
     * @return Data[] Returns an array of Data objects
     */
    public function seasonListData()
    {

        return $this->createQueryBuilder('data')
            ->select("DISTINCT(data.season) as season")
            ->where(" data.season IS NOT NULL ")
            ->orderBy("data.season")
            ->getQuery()
            ->getResult();
    }

    /**
     * get list of season for the filter
     * @return Data[] Returns an array of Data objects
     */
    public function seasonStatistics()
    {
        return $this->createQueryBuilder('data')
            ->select("DISTINCT(data.season) as season")
            ->where("data.season IS NOT NULL ")
            ->orderBy("data.season")
            ->getQuery()
            ->getResult();
    }

// get list of data when the administrtor fill something in the filter

    public function dataExport($filters)
    {
        $qb = $this->createQueryBuilder('data')
            ->select('data, site.zone')
            ->leftJoin('data.site', 'site');

        if (array_key_exists("season", $filters) && $filters['season'] != "") {
            $qb->andWhere('data.season IN (:seasons)')
                ->setParameter('seasons', $filters['season']);
        }
        if (array_key_exists("zone", $filters) && $filters['zone'] != "") {
//            in_array( 30, $filters['zone'] ) ? array_push($filters['zone'],4) : null;
//            in_array( 16, $filters['zone'] ) ? array_push($filters['zone'],26) : null;
            $qb->andWhere("site.id IN (:ids)")
                ->setParameter('ids', $filters['zone']);
        }
        if (array_key_exists("age", $filters) && $filters['age'] != "") {
            $age = explode(',', $filters['age']);

            $qb->andWhere("data.age between :min and :max")
                ->setParameter('min', (int)$age[0])
                ->setParameter('max', (int)$age[1]);
        }
        return $qb->getQuery()->getArrayResult();
    }

    /**
     * get list of ids wp
     * @return Data[] Returns an array of Data objects
     */
    public function removeListData($entriesIds)
    {
        $nbDeletedRows = $this->createQueryBuilder('data')
            ->delete()
            ->where('data.idWp IS NOT NULL')
            ->andWhere('data.idWp not IN (:ids)')
            ->setParameter('ids', $entriesIds)
            ->getQuery()
            ->execute();

        return $nbDeletedRows;
    }
}
