<?php
/**
 * Created by PhpStorm.
 * User: ELLIGY
 * Date: 15/03/2020
 * Time: 23:06
 */

namespace App\Listener;

use App\Entity\Main\ActualityReport;
use App\Entity\Main\ActualityService;
use App\Entity\Main\Alert;
use App\Entity\Main\BusinessPlanService;
use App\Entity\Main\BusinessPlanServiceExample;
use App\Entity\Main\DataFile;
use App\Entity\Main\Demand;
use App\Entity\Main\Historic;
use App\Entity\Main\JuridicalService;
use App\Entity\Main\JuridicalServiceAnswer;
use App\Entity\Main\Manager;
use App\Entity\Main\Message;
use App\Entity\Main\SocietyFilter;
use App\Entity\Main\SurveyAnswer;
use App\Entity\Main\SurveyService;
use App\Entity\Main\User;
use App\Entity\Main\Visitor;
use Doctrine\Common\EventSubscriber;
use Doctrine\Common\Persistence\Event\LifecycleEventArgs;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;

class PersistUpdateListener implements EventSubscriber
{
    private $tokenStorage;
    protected $em;

    public function __construct(
        TokenStorageInterface $tokenStorage,
        EntityManagerInterface $entityManager
    )
    {
        $this->tokenStorage = $tokenStorage;
        $this->em = $entityManager;
    }

    public function getSubscribedEvents() {
        return array('prePersist', 'preUpdate', 'postUpdate');
    }

    public function prePersist(LifecycleEventArgs $args)
    {
        $entity = $args->getObject();
        if ($this->isInstanceHasDate($entity) && !$entity->getCreatedAt()) {
            $entity->setCreatedAt(new \DateTime());
        }
        return;
    }

    public function preUpdate(LifecycleEventArgs $args)
    {
        $entity = $args->getObject();
        if ($this->isInstanceHasDate($entity) && !$entity->getUpdatedAt()) {
            $entity->setUpdatedAt(new \DateTime());
        }
        return;
    }

    public function postPersist(LifecycleEventArgs $args)
    {
        $entity = $args->getObject();
        return;
    }

    public function postUpdate(LifecycleEventArgs $args)
    {
        $entity = $args->getObject();
        return;
    }

    public function isInstanceHasDate($entity){
        return
            $entity instanceof Historic ||
            $entity instanceof Demand ||
            $entity instanceof DataFile;
    }
}
