<?php

namespace App\Entity\Main;

use App\Repository\Main\VisitorRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=VisitorRepository::class)
 * @ORM\HasLifecycleCallbacks()
 */
class Visitor
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $firstName;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $lastName;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $fullName;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $email;

    /**
     * @ORM\Column(type="boolean")
     */
    private $validateCgu;

    /**
     * @ORM\OneToOne(targetEntity=User::class, inversedBy="visitor", cascade={"persist", "remove"})
     * @ORM\JoinColumn(nullable=false)
     */
    private $user;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $dateValidationCgu;

    public function __construct()
    {
        $this->validateCgu = 0;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    public function setFirstName(?string $firstName): self
    {
        $this->firstName = $firstName;

        return $this;
    }

    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    public function setLastName(?string $lastName): self
    {
        $this->lastName = $lastName;

        return $this;
    }

    public function getFullName(): ?string
    {
        return $this->fullName;
    }

    /**
     * @ORM\PrePersist
     */
    public function persistFullName()
    {
        $this->fullName = ucwords(strtolower($this->getFirstName() . ' ' . $this->getLastName() ));
    }

    /**
     * @ORM\PreUpdate
     */
    public function updateFullName()
    {
        $this->fullName = ucwords(strtolower($this->getFirstName() . ' ' . $this->getLastName() ));
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): self
    {
        $this->email = $email;

        return $this;
    }

    public function getValidateCgu(): ?bool
    {
        return $this->validateCgu;
    }

    public function setValidateCgu(bool $validateCgu): self
    {
        $this->validateCgu = $validateCgu;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(User $user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getDateValidationCgu(): ?\DateTimeInterface
    {
        return $this->dateValidationCgu;
    }

    public function setDateValidationCgu(?\DateTimeInterface $dateValidationCgu): self
    {
        $this->dateValidationCgu = $dateValidationCgu;

        return $this;
    }
}
