<?php
// src/Entity/User.php

namespace App\Entity\Main;

use App\Repository\Main\UserRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use FOS\UserBundle\Model\User as BaseUser;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=UserRepository::class)
 * @ORM\Table(name="user")
 */
class User extends BaseUser
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(type="text")
     */
    private $fullName;

    /**
     * @ORM\OneToOne(targetEntity=Manager::class, mappedBy="user", cascade={"persist", "remove"})
     */
    private $manager;

    /**
     * @ORM\Column(type="string", length=8, nullable=true)
     */
    private $temporaryPassword;

    /**
     * @ORM\OneToOne(targetEntity=Visitor::class, mappedBy="user", cascade={"persist", "remove"})
     */
    private $visitor;

    /**
     * @ORM\OneToMany(targetEntity=Historic::class, mappedBy="user")
     */
    private $historics;

    /**
     * @ORM\OneToMany(targetEntity=Demand::class, mappedBy="user")
     */
    private $demands;

    public function __construct()
    {
        parent::__construct();
        $this->historics = new ArrayCollection();
        $this->demands = new ArrayCollection();
    }

    public function __toString()
    {
        return $this->fullName;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getFullName(): ?string
    {
        return $this->fullName;
    }

    public function setFullName(string $fullName): self
    {
        $this->fullName = $fullName;

        return $this;
    }

    public function getManager(): ?Manager
    {
        return $this->manager;
    }

    public function setManager(Manager $manager): self
    {
        // set the owning side of the relation if necessary
        if ($manager->getUser() !== $this) {
            $manager->setUser($this);
        }

        $this->manager = $manager;

        return $this;
    }

    public function getTemporaryPassword(): ?string
    {
        return $this->temporaryPassword;
    }

    public function setTemporaryPassword(?string $temporaryPassword): self
    {
        $this->temporaryPassword = $temporaryPassword;

        return $this;
    }

    public function getVisitor(): ?Visitor
    {
        return $this->visitor;
    }

    public function setVisitor(Visitor $visitor): self
    {
        // set the owning side of the relation if necessary
        if ($visitor->getUser() !== $this) {
            $visitor->setUser($this);
        }

        $this->visitor = $visitor;

        return $this;
    }

    /**
     * @return Collection|Historic[]
     */
    public function getHistorics(): Collection
    {
        return $this->historics;
    }

    public function addHistoric(Historic $historic): self
    {
        if (!$this->historics->contains($historic)) {
            $this->historics[] = $historic;
            $historic->setUser($this);
        }

        return $this;
    }

    public function removeHistoric(Historic $historic): self
    {
        if ($this->historics->removeElement($historic)) {
            // set the owning side to null (unless already changed)
            if ($historic->getUser() === $this) {
                $historic->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Demand[]
     */
    public function getDemands(): Collection
    {
        return $this->demands;
    }

    public function addDemand(Demand $demand): self
    {
        if (!$this->demands->contains($demand)) {
            $this->demands[] = $demand;
            $demand->setUser($this);
        }

        return $this;
    }

    public function removeDemand(Demand $demand): self
    {
        if ($this->demands->removeElement($demand)) {
            // set the owning side to null (unless already changed)
            if ($demand->getUser() === $this) {
                $demand->setUser(null);
            }
        }

        return $this;
    }

}
