<?php

namespace App\Entity\Main;

use App\Repository\Main\DashboardUserExportRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=DashboardUserExportRepository::class)
 */
class DashboardUserExport
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $emailAdress;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $fullname;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $institution;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $country;

    /**
     * @ORM\Column(type="integer")
     */
    private $graphNumber;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $graphName;

    /**
     * @ORM\Column(type="string", length=255, unique = true)
     */
    private $token;

    /**
     * @ORM\Column(type="datetime")
     */
    private $expiresAt;

    /**
     * @ORM\Column(type="boolean")
     */
    private $isUsed;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    private $CreatedAt;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    private $UpdatedAt;

    public function __construct()
    {
        $this->token = bin2hex(random_bytes(16)); // Génération d'un jeton unique
        $this->expiresAt = (new \DateTime())->modify('+48 hours'); // Définit la date d'expiration à 48 heures
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getEmailAdress(): ?string
    {
        return $this->emailAdress;
    }

    public function setEmailAdress(string $emailAdress): self
    {
        $this->emailAdress = $emailAdress;

        return $this;
    }

    public function getFullname(): ?string
    {
        return $this->fullname;
    }

    public function setFullname(string $fullname): self
    {
        $this->fullname = $fullname;

        return $this;
    }

    public function getInstitution(): ?string
    {
        return $this->institution;
    }

    public function setInstitution(string $institution): self
    {
        $this->institution = $institution;

        return $this;
    }

    public function getCountry(): ?string
    {
        return $this->country;
    }

    public function setCountry(string $country): self
    {
        $this->country = $country;

        return $this;
    }

    public function getGraphNumber(): ?int
    {
        return $this->graphNumber;
    }

    public function setGraphNumber(int $graphNumber): self
    {
        $this->graphNumber = $graphNumber;

        return $this;
    }

    public function getGraphName(): ?string
    {
        return $this->graphName;
    }

    public function setGraphName(string $graphName): self
    {
        $this->graphName = $graphName;

        return $this;
    }

    public function getToken(): ?string
    {
        return $this->token;
    }

    public function setToken(string $token): self
    {
        $this->token = $token;

        return $this;
    }

    public function getExpiresAt(): ?\DateTimeInterface
    {
        return $this->expiresAt;
    }

    public function setExpiresAt(\DateTimeInterface $expiresAt): self
    {
        $this->expiresAt = $expiresAt;

        return $this;
    }

    public function getIsUsed(): ?bool
    {
        return $this->isUsed;
    }

    public function setIsUsed(bool $isUsed): self
    {
        $this->isUsed = $isUsed;

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeInterface
    {
        return $this->CreatedAt;
    }

    public function setCreatedAt(?\DateTimeInterface $CreatedAt): self
    {
        $this->CreatedAt = $CreatedAt;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeInterface
    {
        return $this->UpdatedAt;
    }

    public function setUpdatedAt(?\DateTimeInterface $UpdatedAt): self
    {
        $this->UpdatedAt = $UpdatedAt;

        return $this;
    }
}
