<?php

namespace App\Controller;

use App\Entity\Main\Data;
use App\Entity\Main\Site;
use App\Service\AppParams;
use App\Service\EmailsTemplateSender;
use App\Service\Functions;
use App\Service\GihsnWpApiService;
use App\Service\GlobalServices;
use Doctrine\DBAL\Driver\Connection;
use Doctrine\ORM\EntityManagerInterface;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use function Symfony\Component\VarDumper\Dumper\esc;
use Exception;

class ImportController extends AbstractController
{

    protected $em;
    protected $globalServices;
    private $functions;
    private $emailsTemplateSender;
    private $appParams;
    protected $gihsnWpApiService;
    private $conn;


    public function __construct(EntityManagerInterface $entityManager,
                                GlobalServices         $globalServices,
                                Functions              $functions,
                                EmailsTemplateSender   $emailsTemplateSender,
                                AppParams              $appParams,
                                GihsnWpApiService      $gihsnWpApiService,
                                Connection             $conn)
    {
        $this->em = $entityManager;
        $this->globalServices = $globalServices;
        $this->functions = $functions;
        $this->emailsTemplateSender = $emailsTemplateSender;
        $this->appParams = $appParams;
        $this->gihsnWpApiService = $gihsnWpApiService;
        $this->conn = $conn;
    }


//    /**
//     * @Route("/import", name="import")
//     */
//    public function import(Request $request): Response
//    {
//        $datedebut = microtime(true);
////        ini_set("memory_limit", "4096M");
//        set_time_limit(7200);
//        ini_set("max-execution_time", 0);
//        ini_set('memory_limit', '-1');
//
//        $connPhilippe = \Doctrine\DBAL\DriverManager::getConnection(['url' => $this->getParameter("DATABASE_URL_PHILIPPE")]);
//
//        // connect to db gihsn
//        $connGIHSN = \Doctrine\DBAL\DriverManager::getConnection(['url' => $this->getParameter("DATABASE_URL")]);
//
//        $arraylistIdsSites = [];
//        $idsSites = $connGIHSN->fetchAll("SELECT id FROM `site`");
//        foreach ($idsSites as $site) {
//            array_push($arraylistIdsSites, $site['id']);
//        }
//
//        // changement du type du champ id bdd philippe de texte vers varchar + déclaration du champ comme index pour accélérer
//
//
//        // Préparation de la pagination traitement par lots de 1000 enregistrements
//        $parPage = 1000;
//        $total = $connPhilippe->fetchAll("SELECT count(*) AS nb FROM survey ");
//        $total = $total[0]['nb'];
//        $pages = (int)ceil($total / $parPage);
//        $result = [];
//        $nbLines = 0;
//        for ($i = 1; $i <= $pages; $i++) {
//            $from = ($i * $parPage) - $parPage;
//            $data = $this->__traitement($from, $parPage, $arraylistIdsSites);
//            if (count($data) > 0) {
//                $nbLines = $nbLines + count($data);
//                foreach ($data as $item) {
//                    array_push($result, $item);
//                }
//            }
//        }
//
//        $temps = microtime(true) - $datedebut;
//        //  if the number of lines contains errors greater than 0,
//        //  then we will export the result in an excel file and we will send the file in the email
//        if ($nbLines > 0) {
//            $header = array('id_philippe', 'fields');
//            $filename = 'WRONG_DATA_IMPORT_DB_PHILIPPE_' . (new \DateTime())->format('d_m_Y_H_i') . '.xlsx';
//            $spreadsheet = new Spreadsheet();
//            $Excel_writer = new Xlsx($spreadsheet);
//            $spreadsheet->setActiveSheetIndex(0);
//            $activeSheet = $spreadsheet->getActiveSheet();
//
//            $col = 0;
//            foreach ($header as $key => $label) {
//                $activeSheet->setCellValue($this->functions->excelCellName($col) . '1', $label);
//                $col++;
//            }
//            $row = 2;
//            foreach ($result as $line) {
//                $col = 0;
//                foreach ($header as $key => $label) {
//                    if (is_array($line[$label])) {
//                        $value = "";
//                        foreach ($line[$label] as $item) {
//                            $value = $value . $item['field'] . ', ';
//                        }
//                    } else {
//                        $value = $line[$label];
//                    }
//                    $activeSheet->setCellValue($this->functions->excelCellName($col) . $row, $value);
//                    $col++;
//                }
//                $row++;
//            }
//            header('Content-Type: application/vnd.ms-excel');
//            header('Cache-Control: max-age=0');
//            $Excel_writer->save($this->getParameter('absolute_import_directory') . '/' . $filename);
//            $this->emailsTemplateSender->email_after_import_data($result, $this->appParams->getParamByKey('email_admin'), $request->getSchemeAndHttpHost() . '/uploads/import/' . $filename);
//        }
//
//        // récupérer tous les identifiants dans la base de donnees PHILIPPE
//        // Ensuite si on trouve un identifiant différent a les identifiants dans la base du PHILIPPE dans la base du GIHSN alors on le supprime.
//        $listIdsLinesDataOfPhilippeDeleted = $this->conn->fetchAll("SELECT id FROM `data` WHERE  (id_bdd_philippe > 0 AND id_bdd_philippe NOT IN ('" . implode("', '", array_column($connPhilippe->fetchAll("SELECT id FROM survey"), 'id')) . "'))");
//        if (count($listIdsLinesDataOfPhilippeDeleted) > 0) {
//            $this->conn->exec("DELETE FROM `data` WHERE id IN ('" . implode("', '", array_column($listIdsLinesDataOfPhilippeDeleted, 'id')) . "')");
//        }
//
//        return new Response("<html><body>Import base de données philippe terminé (temps : $temps en seconde) avec $nbLines lignes erronées. </body></html>");
//    }

//    /**
//     * import des données depuis la base de données de philippe vers la base de données de GIHSN table "data"
//     */
//    private function __traitement($from, $to, $listIdsSites, $where = " ")
//    {
//        // connection to PHILIPPE DB
//        $connPhilippe = \Doctrine\DBAL\DriverManager::getConnection(['url' => $this->getParameter("DATABASE_URL_PHILIPPE")]);
//
//        // select all fileds to be imported to DB GIHSN
//        // calcule season according to both_doa, Exemple: season= 21_22 si la variable both_doa est <= 31/10/22
//        // Season 22_23 si both_doa compris entre 01/11/2022 et 31/10/2023
//        // Season 23_24 si both_doa compris entre 01/11/2023 et 31/10/2024 ...
//        // fix dates in d/m/Y format in case we have fields of the different style of date
//        // les sites id 30 et 26 n'existent plus donc ils sont remplacés par: 30==>4 , 26==>4
//        $sqlGetDataFromPhilippeDB = "
//        SELECT
//        id AS id_bdd_philippe, `date_last_modified`, `id_last_modificator`, `name_last_modificator`, `is_validated`, `form_type`,
//        if(id_site = 30, 4, if(id_site = 26, 16, id_site )) AS site_id,
//        both_display_hasonesymptoms,
//        both_display_ilisystemic,
//        both_ilisystemic_fever,
//        both_ilisystemic_malaise,
//        both_ilisystemic_headache,
//        both_ilisystemic_myalgia,
//        both_display_ilirespiratory,
//        both_ilirespiratory_cough,
//        both_ilirespiratory_sorethroat,
//        both_ilirespiratory_shortnessbreath,
//        both_ilirespiratory_wheezing,
//        both_ilirespiratory_nasalcongestion,
//        both_othersymptoms_chestpain,
//        both_pregnancy_status,
//        both_pregnancy_weeks,
//        both_pregnancy_weeks_unknow,
//        both_height,
//        both_height_unknow,
//        both_weight,
//        both_weight_unknow,
//        both_chronic_malnutri,
//        both_chronic_hiv_infection ,
//        both_chronic_hemoglobinopathies,
//        both_chronic_hiv_exposure ,
//        both_chronic_prematurity,
//        both_severity_apnea,
//        both_frailty_score,
//        both_frailty_score_unknow,
//        both_frailty_score_discharge_unknow,
//        both_frailty_score_discharge,
//
//
//        DATE_FORMAT(both_doa, '%d%/%m/%Y')                      AS both_doa,
//        DATE_FORMAT(both_swab_date, '%d%/%m/%Y')                AS both_swab_date,
//        DATE_FORMAT(both_antiviral_preceding_date, '%d%/%m/%Y') AS both_antiviral_preceding_date,
//        DATE_FORMAT(both_antiviral_during_date, '%d%/%m/%Y')    AS both_antiviral_during_date,
//        DATE_FORMAT(both_antibio_preceding_date, '%d%/%m/%Y')   AS both_antibio_preceding_date,
//        DATE_FORMAT(both_antibio_during_date, '%d%/%m/%Y')      AS both_antibio_during_date,
//        DATE_FORMAT(both_discharged_date, '%d%/%m/%Y')          AS both_discharged_date,
//
//        DATE_FORMAT(both_covid_last_dose_date, '%d%/%m/%Y')     AS both_covid_last_dose_date,
//        DATE_FORMAT(both_swabcovid_date, '%d%/%m/%Y')           AS both_swabcovid_date,
//
//
//       `both_comp_a_diag`, `both_a_diag_icd`, `both_a_diag`,
//       `both_id_hospital`, `both_id_patient`, `both_sex`,
//       `both_age`, `both_age_unit`,
//       `both_swab_date_unknow`, `display_titre_labo`, `both_positive_result`, `both_display_labo2`,
//       `both_lab_flu_h1n1`, `both_lab_flu_h3n2`, `both_lab_flu_yamagata`, `both_lab_flu_victoria`, `both_lab_flu_h1nother`, `both_lab_flu_h3nother`, `both_lab_flu_a_nosub`, `both_lab_flu_b_nosub`,
//       `both_test_other_virus`, `both_display_test_other2`, `both_lab2_sarscov2`, `both_lab2_sarscov2_yesno`, `both_lab2_corona`, `both_lab2_corona_yesno`,
//       `both_lab2_metaneumo`, `both_lab2_metaneumo_yesno`, `both_lab2_rs`, `both_lab2_rs_yesno`, `both_lab2_adeno`, `both_lab2_adeno_yesno`, `both_lab2_boca`,
//       `both_lab2_boca_yesno`, `both_lab2_pi`, `both_lab2_pi_yesno`, `both_lab2_rhino`, `both_lab2_rhino_yesno`, `both_lab2_others`, `both_lab2_others_yesno`,
//       `both_display_hasothersymptoms`, `both_othersymptoms_nausea`, `both_othersymptoms_diarrhea`, `both_othersymptoms_smell`,
//       `both_display_clinical2`, `both_chronic_cond_yn`, `both_display_clinical3`, `both_chronic_cvd_blood`, `both_chronic_copd`,
//       `both_chronic_asthma`, `both_chronic_diabetes`, `both_chronic_immuno`, `both_chronic_renal`, `both_chronic_rheumatologic_autoimmune_dis`,
//       `both_chronic_neurological_neuromuscular_dis`, `both_chronic_cirrhosis_liver_dis`, `both_chronic_neoplasm`, `both_chronic_obesity`,
//       `both_chronic_active_tuberculosis`,
//       `both_chronic_other`, `both_antiviral_preceding`,
//       `both_antiviral_during`, `both_antibio_preceding`,
//       `both_antibio_during`,  `both_display_clinical4`, `both_display_clinical5`, `both_influ_vac_current_season`,
//       `both_vac_14d_before_ili_sym`, `both_vac_history_validated`, `both_vac_preceding_season`, `both_display_clinical6`, `both_severity_confusion`,
//       `both_severity_blood_pressure`, `both_severity_blood_pressure_unknow`, `both_severity_respiration_rate`, `both_severity_respiration_rate_unknow`,
//       `both_severity_oxygen_saturation`,
//       `both_severity_oxygen_saturation_unknow`, `both_severity_supp_oxygen`, `both_severity_vaso_support`, `both_display_clinical6b`, `both_icu_adm`,
//       `both_severity_mech_vent`,
//       `both_display_clinical7`, `both_death_hosp`, `both_discharge_another_hopital`, `both_d_icd`, `both_d_diag1`,
//       `both_d_diag2`, `both_d_diag3`,
//       `both_display_gisaid`, `both_sample_submited`, `both_epi_isl`,`both_covid_last_dose_date_unknow`,
//
//        `both_display_intro`, `both_display_how_patient_was_identified`, `both_a_diag_unknow`, `both_case_identified_based_logs_respiratory`, `both_case_identified_based_positive_swab`,
//        `both_case_definition_used`, `both_case_definition_other_detail`, `both_lab2_others_detail` , `both_antiviral_preceding_date_unknow`, `both_antiviral_during_date_unknow`,
//        `both_antibio_preceding_date_unknow`, `both_antibio_during_date_unknow`, `both_vac_type_vaccine`, `both_display_clinical5bis`, LOWER(`both_covid_number_doses`) AS both_covid_number_doses,
//        `both_display_covid_vaccine`, `both_covid_vaccine_mrna`, `both_covid_vaccine_inactivated_virion`, `both_covid_vaccine_viral_vector`, `both_covid_vaccine_protein_subunit`,
//        `both_covid_vaccine_unknow`, `both_severity_high_dependence_unit`,`both_d_diag1_unknow`,`both_d_diag2_unknow`, `both_d_diag3_unknow`,
//        `both_sample_type`, `both_swabcovid_date_unknow`, id_site AS `id_site_bdd_philippe`,
//
//         CASE
//             WHEN( DATE_FORMAT(both_doa, '%Y-%m-%d') < '2022-11-01' ) THEN '21_22'
//             WHEN( DATE_FORMAT(both_doa, '%Y-%m-%d') > CONCAT( DATE_FORMAT(both_doa, '%Y'), '-11-01' ) OR DATE_FORMAT(both_doa, '%Y-%m-%d') = CONCAT( DATE_FORMAT(both_doa, '%Y'), '-11-01' ) ) THEN CONCAT( DATE_FORMAT(both_doa, '%y'), '_', DATE_FORMAT( DATE_ADD(both_doa, INTERVAL 1 YEAR), '%y' ) )
//             WHEN( DATE_FORMAT(both_doa, '%Y-%m-%d') < CONCAT( DATE_FORMAT(both_doa, '%Y'), '-10-31' ) OR DATE_FORMAT(both_doa, '%Y-%m-%d') = CONCAT( DATE_FORMAT(both_doa, '%Y'), '-10-31' ) ) THEN CONCAT( DATE_FORMAT( DATE_SUB(both_doa, INTERVAL 1 YEAR), '%y' ), '_', DATE_FORMAT(both_doa, '%y') )  END as season,
//           1 AS tocalculate
//        FROM survey
//        $where
//        limit $from, $to";
//
//
//        $listDataFromPhilippeDB = $connPhilippe->fetchAll($sqlGetDataFromPhilippeDB);
//
//        // verification of data  of DB philippe after insert/update in the DB GIHSN
//        //  if we find variables that do not respect the given formats, we put it in the array $wrongFieldsInDBPhilippe.
//        $wrongFieldsInDBPhilippe = [];
//
//        for ($i = 0; $i < count($listDataFromPhilippeDB); $i++) {
//            $importDBPhilippe = true;
//            $field = [];
//            $age = null;
//            if (array_key_exists("both_age", $listDataFromPhilippeDB[$i]) && $listDataFromPhilippeDB[$i]['both_age'] != null && array_key_exists("both_age_unit", $listDataFromPhilippeDB[$i]) && $listDataFromPhilippeDB[$i]['both_age_unit'] != null) {
//                if ($listDataFromPhilippeDB[$i]['both_age_unit'] == 1) {
//                    $age = $listDataFromPhilippeDB[$i]['both_age'];
//                } elseif ($listDataFromPhilippeDB[$i]['both_age_unit'] == 2) {
//                    $age = $listDataFromPhilippeDB[$i]['both_age'] / 12;
//                } elseif ($listDataFromPhilippeDB[$i]['both_age_unit'] == 3) {
//                    $age = $listDataFromPhilippeDB[$i]['both_age'] / 365;
//                }
//            }
//            if ($listDataFromPhilippeDB[$i]) {
//                if (array_key_exists("site_id", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['site_id'], $listIdsSites)) {
//                        $importDBPhilippe = false;
//                        array_push($field, ['field' => 'site_id']);
//                    }
//                }
//                if (array_key_exists("both_comp_a_diag", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_comp_a_diag'], [0, 1])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_comp_a_diag']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_comp_a_diag'] == null) {
//                        array_push($field, ['field' => 'both_comp_a_diag']);
//                    }
//                }
//                if (array_key_exists("both_a_diag", $listDataFromPhilippeDB[$i]) && array_key_exists("both_a_diag_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_a_diag'] != null && ($listDataFromPhilippeDB[$i]['both_a_diag_unknow'] == null) || $listDataFromPhilippeDB[$i]['both_a_diag_unknow'] == 0) {
//                        $bool = true;
//                        $replace = array('[', ']', '"', ' ', "'");
//                        $result = str_replace($replace, "", $listDataFromPhilippeDB[$i]['both_a_diag']);
//                        $result_both_a_diag = explode(',', $result);
//                        if (count($result_both_a_diag) == 1) {
//                            if (!preg_match('/^([0-9]{3,3})$|^([A-Z]{1}[0-9]{2})$|^([0-9]{3}\.[0-9]{1,2})$|^([A-Z]{1}[0-9]{2}\.[0-9]{1,2})$/', $result_both_a_diag[0])) {
//                                $bool = false;
//                            }
//                        } else if (count($result_both_a_diag) > 1) {
//                            foreach ($result_both_a_diag as $item) {
//                                if (!preg_match('/^([0-9]{3,3})$|^([A-Z]{1}[0-9]{2})$|^([0-9]{3}\.[0-9]{1,2})$|^([A-Z]{1}[0-9]{2}\.[0-9]{1,2})$/', $item)) {
//                                    $bool = false;
//                                }
//                            }
//                        }
//                        if (!$bool) {
////                        // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_a_diag']);
//                        }
//                    } elseif (($listDataFromPhilippeDB[$i]['both_a_diag'] != null && $listDataFromPhilippeDB[$i]['both_a_diag_unknow'] == 1) || ($listDataFromPhilippeDB[$i]['both_a_diag_unknow'] == 0 && $listDataFromPhilippeDB[$i]['both_a_diag'] == null)) {
//                        array_push($field, ['field' => 'both_a_diag']);
//                    }
//                } else {
//                    array_push($field, ['field' => 'both_a_diag']);
//                }
//
//                if (array_key_exists("both_a_diag_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_a_diag_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_a_diag_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_a_diag_unknow']);
//                    }
//                }
//                if (array_key_exists("both_a_diag_icd", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_a_diag_icd'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_a_diag_icd'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_a_diag_icd']);
//                    }
//                }
////                both_display_how_patient_was_identified
//                if (array_key_exists("both_case_identified_based_logs_respiratory", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_case_identified_based_logs_respiratory'], [0, 1])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_case_identified_based_logs_respiratory']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_case_identified_based_logs_respiratory'] == null) {
//                        array_push($field, ['field' => 'both_case_identified_based_logs_respiratory']);
//                    }
//                }
//                if (array_key_exists("both_case_identified_based_positive_swab", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_case_identified_based_positive_swab'], [0, 1])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_case_identified_based_positive_swab']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_case_identified_based_positive_swab'] == null) {
//                        array_push($field, ['field' => 'both_case_identified_based_positive_swab']);
//                    }
//                }
//                if (array_key_exists("both_case_definition_used", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_case_definition_used'], [1, 2, 3, 4, 5, 6, 7])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_case_definition_used']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_case_definition_used'] == null) {
//                        array_push($field, ['field' => 'both_case_definition_used']);
//                    }
//                }
//                if (array_key_exists("both_doa", $listDataFromPhilippeDB[$i])) {
//                    if (!preg_match("/^([0-9]{2})\/([0-9]{2})\/([0-9]{4})$/", $listDataFromPhilippeDB[$i]['both_doa'])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_doa']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_doa'] == null) {
//                        array_push($field, ['field' => 'both_doa']);
//                    }
//                }
//                if (array_key_exists("both_id_hospital", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_id_hospital'] == null || $listDataFromPhilippeDB[$i]['both_id_hospital'] == '') {
////                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_id_hospital']);
//                    }
//                }
//                if (array_key_exists("both_id_patient", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_id_patient'] == null || $listDataFromPhilippeDB[$i]['both_id_patient'] == '') {
////                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_id_patient']);
//                    }
//                }
//                if (array_key_exists("both_sex", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_sex'], [0, 1])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_sex']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_sex'] == null) {
//                        array_push($field, ['field' => 'both_sex']);
//                    }
//                }
//                if (array_key_exists("both_chronic_cond_yn", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_cond_yn'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_cond_yn']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_chronic_cond_yn'] == null) {
//                        array_push($field, ['field' => 'both_chronic_cond_yn']);
//                    }
//                }
//                //both_display_clinical3
//                if (array_key_exists("both_chronic_cvd_blood", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_cvd_blood'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_cvd_blood'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_cvd_blood']);
//                    }
//                }
//                if (array_key_exists("both_chronic_copd", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_copd'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_copd'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_copd']);
//                    }
//                }
//                if (array_key_exists("both_chronic_asthma", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_asthma'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_asthma'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_asthma']);
//                    }
//                }
//                if (array_key_exists("both_chronic_diabetes", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_diabetes'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_diabetes'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_diabetes']);
//                    }
//                }
//                if (array_key_exists("both_chronic_immuno", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_immuno'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_immuno'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_immuno']);
//                    }
//                }
//                if (array_key_exists("both_chronic_renal", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_renal'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_renal'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_renal']);
//                    }
//                }
//                if (array_key_exists("both_chronic_rheumatologic_autoimmune_dis", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_rheumatologic_autoimmune_dis'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_rheumatologic_autoimmune_dis'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_rheumatologic_autoimmune_dis']);
//                    }
//                }
//                if (array_key_exists("both_chronic_neurological_neuromuscular_dis", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_neurological_neuromuscular_dis'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_neurological_neuromuscular_dis'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_neurological_neuromuscular_dis']);
//                    }
//                }
//                if (array_key_exists("both_chronic_cirrhosis_liver_dis", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_cirrhosis_liver_dis'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_cirrhosis_liver_dis'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_cirrhosis_liver_dis']);
//                    }
//                }
//                if (array_key_exists("both_chronic_neoplasm", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_neoplasm'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_neoplasm'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_neoplasm']);
//                    }
//                }
//                if (array_key_exists("both_chronic_obesity", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_obesity'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_obesity'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_obesity']);
//                    }
//                }
//                if (array_key_exists("both_chronic_malnutri", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_malnutri'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_malnutri'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_malnutri']);
//                    }
//                }
//                if (array_key_exists("both_chronic_active_tuberculosis", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_active_tuberculosis'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_chronic_active_tuberculosis'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_active_tuberculosis']);
//                    }
//                }
//                if (array_key_exists("both_chronic_hiv_infection", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_hiv_infection'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_hiv_infection'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_hiv_infection']);
//                    }
//                }
//                if (array_key_exists("both_chronic_hiv_exposure", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_hiv_exposure'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_hiv_exposure'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_hiv_exposure']);
//                    }
//                }
//                if (array_key_exists("both_chronic_other", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_other'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_other'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_other']);
//                    }
//                }
//                if (array_key_exists("both_influ_vac_current_season", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_influ_vac_current_season'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_influ_vac_current_season']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_influ_vac_current_season'] == null) {
//                        array_push($field, ['field' => 'both_influ_vac_current_season']);
//                    }
//                }
//                if (array_key_exists("both_vac_14d_before_ili_sym", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_vac_14d_before_ili_sym'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_vac_14d_before_ili_sym'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_vac_14d_before_ili_sym']);
//                    }
//                }
//                if (array_key_exists("both_vac_preceding_season", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_vac_preceding_season'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_vac_preceding_season']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_vac_preceding_season'] == null) {
//                        array_push($field, ['field' => 'both_vac_preceding_season']);
//                    }
//                }
//
//                if (array_key_exists("both_swab_date", $listDataFromPhilippeDB[$i]) && array_key_exists("both_swab_date_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_swab_date_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_swab_date'] != null) {
//                        if (!preg_match("/^([0-9]{2})\/([0-9]{2})\/([0-9]{4})$/", $listDataFromPhilippeDB[$i]['both_swab_date'])) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_swab_date']);
//                        }
//                    } elseif (($listDataFromPhilippeDB[$i]['both_swab_date_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_swab_date'] != null) || ($listDataFromPhilippeDB[$i]['both_swab_date_unknow'] == null && $listDataFromPhilippeDB[$i]['both_swab_date'] == null)) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_swab_date']);
//                    }
//                }
//
//                if (array_key_exists("both_swab_date_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_swab_date_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_swab_date_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_swab_date_unknow']);
//                    }
//                }
//
//                if (array_key_exists("both_severity_oxygen_saturation", $listDataFromPhilippeDB[$i]) && array_key_exists("both_severity_oxygen_saturation_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_severity_oxygen_saturation_unknow'] == null && $listDataFromPhilippeDB[$i]['both_severity_oxygen_saturation'] != null) {
//                        if ((!preg_match("/^[0-9]{1,3}$/", $listDataFromPhilippeDB[$i]['both_severity_oxygen_saturation']) || (strlen($listDataFromPhilippeDB[$i]['both_severity_oxygen_saturation']) > 3)) && $listDataFromPhilippeDB[$i]['both_severity_oxygen_saturation'] != null) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_severity_oxygen_saturation']);
//                        }
//                    } elseif (($listDataFromPhilippeDB[$i]['both_severity_oxygen_saturation_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_severity_oxygen_saturation'] != null) || $listDataFromPhilippeDB[$i]['both_severity_oxygen_saturation_unknow'] == null && $listDataFromPhilippeDB[$i]['both_severity_oxygen_saturation'] == null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_severity_oxygen_saturation']);
//                    }
//                }
//
//                if (array_key_exists("both_severity_oxygen_saturation_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_severity_oxygen_saturation_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_severity_oxygen_saturation_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_severity_oxygen_saturation_unknow']);
//                    }
//                }
//
//                if (array_key_exists("both_severity_blood_pressure", $listDataFromPhilippeDB[$i]) && array_key_exists("both_severity_blood_pressure_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_severity_blood_pressure_unknow'] == null && $listDataFromPhilippeDB[$i]['both_severity_blood_pressure'] != null) {
//                        if ((!preg_match("/^[0-9]{3}\/[0-9]{3}$/", $listDataFromPhilippeDB[$i]['both_severity_blood_pressure']) || (strlen($listDataFromPhilippeDB[$i]['both_severity_blood_pressure']) != 7)) && $listDataFromPhilippeDB[$i]['both_severity_blood_pressure'] != null) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_severity_blood_pressure']);
//                        }
//                    } elseif (($listDataFromPhilippeDB[$i]['both_severity_blood_pressure_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_severity_blood_pressure'] != null) || ($listDataFromPhilippeDB[$i]['both_severity_blood_pressure_unknow'] == null && $listDataFromPhilippeDB[$i]['both_severity_blood_pressure'] == null)) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_severity_blood_pressure']);
//                    }
//                }
//
//                if (array_key_exists("both_severity_blood_pressure_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_severity_blood_pressure_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_severity_blood_pressure_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_severity_blood_pressure_unknow']);
//                    }
//                }
//
//                if (array_key_exists("both_severity_respiration_rate", $listDataFromPhilippeDB[$i]) && array_key_exists("both_severity_respiration_rate_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_severity_respiration_rate_unknow'] == null && $listDataFromPhilippeDB[$i]['both_severity_respiration_rate'] != null) {
//                        if (((!preg_match("/^[0-9]{1,2}$/", $listDataFromPhilippeDB[$i]['both_severity_respiration_rate'])) || (strlen($listDataFromPhilippeDB[$i]['both_severity_respiration_rate']) > 2)) && (strlen($listDataFromPhilippeDB[$i]['both_severity_respiration_rate']) != null)) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_severity_respiration_rate']);
//                        }
//                    } elseif (($listDataFromPhilippeDB[$i]['both_severity_respiration_rate_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_severity_respiration_rate'] != null) || ($listDataFromPhilippeDB[$i]['both_severity_respiration_rate_unknow'] == null && $listDataFromPhilippeDB[$i]['both_severity_respiration_rate'] == null)) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_severity_respiration_rate']);
//                    }
//                }
//
//                if (array_key_exists("both_severity_respiration_rate_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_severity_respiration_rate_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_severity_respiration_rate_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_severity_respiration_rate_unknow']);
//                    }
//                }
//                if (array_key_exists("both_severity_supp_oxygen", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_severity_supp_oxygen'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_severity_supp_oxygen']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_severity_supp_oxygen'] == null) {
//                        array_push($field, ['field' => 'both_severity_supp_oxygen']);
//                    }
//                }
//                if (array_key_exists("both_severity_vaso_support", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_severity_vaso_support'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_severity_vaso_support']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_severity_vaso_support'] == null) {
//                        array_push($field, ['field' => 'both_severity_vaso_support']);
//                    }
//                }
//                if (array_key_exists("both_icu_adm", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_icu_adm'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_icu_adm']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_icu_adm'] == null) {
//                        array_push($field, ['field' => 'both_icu_adm']);
//                    }
//                }
//                if (array_key_exists("both_death_hosp", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_death_hosp'], [0, 1])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_death_hosp']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_death_hosp'] == null) {
//                        array_push($field, ['field' => 'both_death_hosp']);
//                    }
//                }
//                if (array_key_exists("both_severity_mech_vent", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_severity_mech_vent'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_severity_mech_vent']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_severity_mech_vent'] == null) {
//                        array_push($field, ['field' => 'both_severity_mech_vent']);
//                    }
//                }
//                if (array_key_exists("both_severity_high_dependence_unit", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_severity_high_dependence_unit'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_severity_high_dependence_unit']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_severity_high_dependence_unit'] == null) {
//                        array_push($field, ['field' => 'both_severity_high_dependence_unit']);
//                    }
//                }
//                if (array_key_exists("both_discharged_date", $listDataFromPhilippeDB[$i])) {
//                    if ((!preg_match("/^([0-9]{2})\/([0-9]{2})\/([0-9]{4})$/", $listDataFromPhilippeDB[$i]['both_discharged_date']))) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_discharged_date']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_discharged_date'] == null) {
//                        array_push($field, ['field' => 'both_discharged_date']);
//                    }
//                }
//
//                if (array_key_exists("both_d_diag1", $listDataFromPhilippeDB[$i]) && array_key_exists("both_d_diag1_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_d_diag1_unknow'] == null && $listDataFromPhilippeDB[$i]['both_d_diag1'] != null) {
//                        if ((!preg_match("/^([0-9]{3})$|^([A-Z]{1}[0-9]{2})$|^([0-9]{3}[.][0-9]{1,2})$|^([A-Z]{1}[0-9]{2}[.][0-9]{1,2})$/", $listDataFromPhilippeDB[$i]['both_d_diag1']) && $listDataFromPhilippeDB[$i]['both_d_diag2'] != NULL)) {
////                        // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_d_diag1']);
//                        }
//                    } elseif ($listDataFromPhilippeDB[$i]['both_d_diag1_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_d_diag1'] != null) {
//                        array_push($field, ['field' => 'both_d_diag1']);
//                    }
//                }
//
//                if (array_key_exists("both_d_diag1_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_d_diag1_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_d_diag1_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_d_diag1_unknow']);
//                    }
//                }
//
//                if (array_key_exists("both_d_diag2", $listDataFromPhilippeDB[$i]) && array_key_exists("both_d_diag2_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_d_diag2_unknow'] == null && $listDataFromPhilippeDB[$i]['both_d_diag2'] != null) {
//                        if ((!preg_match("/^([0-9]{3})$|^([A-Z]{1}[0-9]{2})$|^([0-9]{3}[.][0-9]{1,2})$|^([A-Z]{1}[0-9]{2}[.][0-9]{1,2})$/", $listDataFromPhilippeDB[$i]['both_d_diag2']) && $listDataFromPhilippeDB[$i]['both_d_diag2'] != NULL)) {
////                        // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_d_diag2']);
//                        }
//                    } elseif ($listDataFromPhilippeDB[$i]['both_d_diag2_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_d_diag2'] != null) {
//                        array_push($field, ['field' => 'both_d_diag2']);
//                    }
//                }
//                if (array_key_exists("both_d_diag2_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_d_diag2_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_d_diag2_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_d_diag2_unknow']);
//                    }
//                }
//
//                if (array_key_exists("both_d_diag3", $listDataFromPhilippeDB[$i]) && array_key_exists("both_d_diag3_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_d_diag3_unknow'] == null && $listDataFromPhilippeDB[$i]['both_d_diag3'] != null) {
//                        if ((!preg_match("/^([0-9]{3})$|^([A-Z]{1}[0-9]{2})$|^([0-9]{3}[.][0-9]{1,2})$|^([A-Z]{1}[0-9]{2}[.][0-9]{1,2})$/", $listDataFromPhilippeDB[$i]['both_d_diag3']) && $listDataFromPhilippeDB[$i]['both_d_diag2'] != NULL)) {
////                        // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_d_diag3']);
//                        }
//                    } elseif ($listDataFromPhilippeDB[$i]['both_d_diag3_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_d_diag3'] != null) {
//                        array_push($field, ['field' => 'both_d_diag3']);
//                    }
//                }
//
//                if (array_key_exists("both_d_diag3_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_d_diag3_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_d_diag3_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_d_diag3_unknow']);
//                    }
//                }
//                if (array_key_exists("both_d_icd", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_d_icd'], [0, 1])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_d_icd']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_d_icd'] == null) {
//                        array_push($field, ['field' => 'both_d_icd']);
//                    }
//                }
//                if (array_key_exists("both_positive_result", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_positive_result'], [0, 1, 2])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_positive_result']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_positive_result'] == null) {
//                        array_push($field, ['field' => 'both_positive_result']);
//                    }
//                }
//                //both_display_labo2
//                if (array_key_exists("both_lab_flu_h1n1", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab_flu_h1n1'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab_flu_h1n1'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab_flu_h1n1']);
//                    }
//                }
//                if (array_key_exists("both_lab_flu_h3n2", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab_flu_h3n2'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab_flu_h3n2'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab_flu_h3n2']);
//                    }
//                }
//                if (array_key_exists("both_lab_flu_yamagata", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab_flu_yamagata'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab_flu_yamagata'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab_flu_yamagata']);
//                    }
//                }
//                if (array_key_exists("both_lab_flu_victoria", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab_flu_victoria'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab_flu_victoria'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab_flu_victoria']);
//                    }
//                }
//                if (array_key_exists("both_lab_flu_h1nother", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab_flu_h1nother'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab_flu_h1nother'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab_flu_h1nother']);
//                    }
//                }
//                if (array_key_exists("both_lab_flu_h3nother", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab_flu_h3nother'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab_flu_h3nother'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab_flu_h3nother']);
//                    }
//                }
//                if (array_key_exists("both_lab_flu_a_nosub", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab_flu_a_nosub'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab_flu_a_nosub'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab_flu_a_nosub']);
//                    }
//                }
//                if (array_key_exists("both_lab_flu_b_nosub", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab_flu_b_nosub'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab_flu_b_nosub'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab_flu_b_nosub']);
//                    }
//                }
//                if (array_key_exists("both_lab2_corona_yesno", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_corona_yesno'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab2_corona_yesno'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_corona_yesno']);
//                    }
//                }
//                if (array_key_exists("both_lab2_metaneumo_yesno", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_metaneumo_yesno'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab2_metaneumo_yesno'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_metaneumo_yesno']);
//                    }
//                }
//                if (array_key_exists("both_lab2_rs_yesno", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_rs_yesno'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab2_rs_yesno'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_rs_yesno']);
//                    }
//                }
//                if (array_key_exists("both_lab2_adeno_yesno", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_adeno_yesno'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab2_adeno_yesno'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_adeno_yesno']);
//                    }
//                }
//                if (array_key_exists("both_lab2_boca_yesno", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_boca_yesno'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab2_boca_yesno'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_boca_yesno']);
//                    }
//                }
//                if (array_key_exists("both_lab2_pi_yesno", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_pi_yesno'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab2_pi_yesno'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_pi_yesno']);
//                    }
//
//                }
//                if (array_key_exists("both_lab2_rhino_yesno", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_rhino_yesno'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab2_rhino_yesno'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_rhino_yesno']);
//                    }
//                }
//                if (array_key_exists("both_age", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_age'] == null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_age']);
//                    }
//                }
//                if (array_key_exists("both_age_unit", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_age_unit'], [1, 2, 3])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_age_unit']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_age_unit'] == null) {
//                        array_push($field, ['field' => 'both_age_unit']);
//                    }
//                }
//                //both_display_ilisystemic
//                if (array_key_exists("both_ilisystemic_fever", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_ilisystemic_fever'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_ilisystemic_fever']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_ilisystemic_fever'] == null) {
//                        array_push($field, ['field' => 'both_ilisystemic_fever']);
//                    }
//                }
//                if (array_key_exists("both_ilisystemic_malaise", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_ilisystemic_malaise'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_ilisystemic_malaise']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_ilisystemic_malaise'] == null) {
//                        array_push($field, ['field' => 'both_ilisystemic_malaise']);
//                    }
//                }
//                if (array_key_exists("both_ilisystemic_headache", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_ilisystemic_headache'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_ilisystemic_headache']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_ilisystemic_headache'] == null) {
//                        array_push($field, ['field' => 'both_ilisystemic_headache']);
//                    }
//                }
//                if (array_key_exists("both_ilisystemic_myalgia", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_ilisystemic_myalgia'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_ilisystemic_myalgia']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_ilisystemic_myalgia'] == null) {
//                        array_push($field, ['field' => 'both_ilisystemic_myalgia']);
//                    }
//                }
//                if (array_key_exists("both_ilirespiratory_cough", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_ilirespiratory_cough'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_ilirespiratory_cough']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_ilirespiratory_cough'] == null) {
//                        array_push($field, ['field' => 'both_ilirespiratory_cough']);
//                    }
//                }
//                if (array_key_exists("both_ilirespiratory_sorethroat", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_ilirespiratory_sorethroat'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_ilirespiratory_sorethroat']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_ilirespiratory_sorethroat'] == null) {
//                        array_push($field, ['field' => 'both_ilirespiratory_sorethroat']);
//                    }
//                }
//                //both_display_ilirespiratory
//                if (array_key_exists("both_ilirespiratory_nasalcongestion", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_ilirespiratory_nasalcongestion'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_ilirespiratory_nasalcongestion']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_ilirespiratory_nasalcongestion'] == null) {
//                        array_push($field, ['field' => 'both_ilirespiratory_nasalcongestion']);
//                    }
//                }
//                if (array_key_exists("both_epi_isl", $listDataFromPhilippeDB[$i])) {
//                    if (((!preg_match("/^EPI_ISL_[0-9]{7}$/", $listDataFromPhilippeDB[$i]['both_epi_isl'])) && (strlen($listDataFromPhilippeDB[$i]['both_epi_isl']) != 15) && $listDataFromPhilippeDB[$i]['both_epi_isl'] != null)) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_epi_isl']);
//                    }
//                }
//                // both_display_clinical2
//                // both_display_clinical4
//                // both_display_clinical5
//                // both_display_clinical6
//                // both_display_clinical7
//                if (array_key_exists("both_pregnancy_status", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_pregnancy_status'], [0, 1, 2])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_pregnancy_status']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_pregnancy_status'] == null) {
//                        array_push($field, ['field' => 'both_pregnancy_status']);
//                    }
//                }
//                //both_pregnancy_weeks
//                if (array_key_exists("both_pregnancy_weeks_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_pregnancy_weeks_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_pregnancy_weeks_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_pregnancy_weeks_unknow']);
//                    }
//                }
//                //both_display_hasonesymptoms
//                if (array_key_exists("both_test_other_virus", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_test_other_virus'], [0, 1, 2])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_test_other_virus']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_test_other_virus'] == null) {
//                        array_push($field, ['field' => 'both_test_other_virus']);
//                    }
//                }
//                //both_display_test_other2
//                //display_titre_labo
//
//                if (array_key_exists("both_height", $listDataFromPhilippeDB[$i]) && array_key_exists("both_height_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($age && $age < 5) {
//                        if ($listDataFromPhilippeDB[$i]['both_height_unknow'] == null || $listDataFromPhilippeDB[$i]['both_height_unknow'] == 0) {
//                            if ((!preg_match("/^[0-9]{1,3}$|^[0-9]{1,3}[.][0-9]{1,3}$/", $listDataFromPhilippeDB[$i]['both_height']))) {
//                                // $importDBPhilippe = false;
//                                array_push($field, ['field' => 'both_height']);
//                            }
//                        } else if ($listDataFromPhilippeDB[$i]['both_height_unknow'] == 1) {
//                            if (strlen($listDataFromPhilippeDB[$i]['both_height']) > 0) {
//                                // $importDBPhilippe = false;
//                                array_push($field, ['field' => 'both_height']);
//                            }
//                        } else {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_height']);
//                        }
//                    } else {
//                        if ($listDataFromPhilippeDB[$i]['both_height'] != null && ($listDataFromPhilippeDB[$i]['both_height_unknow'] == null || $listDataFromPhilippeDB[$i]['both_height_unknow'] == 0)) {
//                            if ((!preg_match("/^[0-9]{1,3}$|^[0-9]{1,3}[.][0-9]{1,3}$/", $listDataFromPhilippeDB[$i]['both_height']))) {
//                                // $importDBPhilippe = false;
//                                array_push($field, ['field' => 'both_height']);
//                            }
//                        } elseif (($listDataFromPhilippeDB[$i]['both_height'] != null && $listDataFromPhilippeDB[$i]['both_height_unknow'] == 1) || ($listDataFromPhilippeDB[$i]['both_height'] == null && $listDataFromPhilippeDB[$i]['both_height_unknow'] == null)) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_height']);
//                        }
//                    }
//                } else {
//                    // $importDBPhilippe = false;
//                    array_push($field, ['field' => 'both_height']);
//                }
//                if (array_key_exists("both_weight", $listDataFromPhilippeDB[$i]) && array_key_exists("both_weight_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($age && $age < 5) {
//                        if ($listDataFromPhilippeDB[$i]['both_weight_unknow'] == null || $listDataFromPhilippeDB[$i]['both_weight_unknow'] == 0) {
//                            if ((!preg_match("/^[0-9]{1,3}$|^[0-9]{1,3}[.][0-9]{1,3}$/", $listDataFromPhilippeDB[$i]['both_weight']))) {
//                                // $importDBPhilippe = false;
//                                array_push($field, ['field' => 'both_weight']);
//                            }
//                        } else if ($listDataFromPhilippeDB[$i]['both_weight_unknow'] == 1) {
//                            if (strlen($listDataFromPhilippeDB[$i]['both_weight']) > 0) {
//                                // $importDBPhilippe = false;
//                                array_push($field, ['field' => 'both_weight']);
//                            }
//                        } else {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_weight']);
//                        }
//                    } else {
//                        if ($listDataFromPhilippeDB[$i]['both_weight'] != null && $listDataFromPhilippeDB[$i]['both_weight_unknow'] == null || $listDataFromPhilippeDB[$i]['both_weight_unknow'] == 0) {
//                            if ((!preg_match("/^[0-9]{1,3}$|^[0-9]{1,3}[.][0-9]{1,3}$/", $listDataFromPhilippeDB[$i]['both_weight']))) {
//                                // $importDBPhilippe = false;
//                                array_push($field, ['field' => 'both_weight']);
//                            }
//                        } elseif (($listDataFromPhilippeDB[$i]['both_weight'] != null && $listDataFromPhilippeDB[$i]['both_weight_unknow'] == 1) || ($listDataFromPhilippeDB[$i]['both_weight'] == null && $listDataFromPhilippeDB[$i]['both_weight_unknow'] == null)) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_weight']);
//                        }
//                    }
//                } else {
//                    // $importDBPhilippe = false;
//                    array_push($field, ['field' => 'both_weight']);
//                }
//                if (array_key_exists("both_weight_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_weight_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_weight_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_weight_unknow']);
//                    }
//                }
//                if (array_key_exists("both_height_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_height_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_height_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_height_unknow']);
//                    }
//                }
//                if (array_key_exists("both_chronic_prematurity", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_prematurity'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_prematurity'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_prematurity']);
//                    }
//                }
//                if (array_key_exists("both_chronic_hemoglobinopathies", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_chronic_hemoglobinopathies'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_chronic_hemoglobinopathies'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_chronic_hemoglobinopathies']);
//                    }
//                }
//                if (array_key_exists("both_antibio_preceding", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_antibio_preceding'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_antibio_preceding']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_antibio_preceding'] == null) {
//                        array_push($field, ['field' => 'both_antibio_preceding']);
//                    }
//                }
//
//                if (array_key_exists("both_antibio_preceding_date", $listDataFromPhilippeDB[$i]) && array_key_exists("both_antibio_preceding_date_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_antibio_preceding_date_unknow'] == null && $listDataFromPhilippeDB[$i]['both_antibio_preceding_date'] != null) {
//                        if ((!preg_match("/^([0-9]{2})\/([0-9]{2})\/([0-9]{4})$/", $listDataFromPhilippeDB[$i]['both_antibio_preceding_date']))) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_antibio_preceding_date']);
//                        }
//                    } elseif (($listDataFromPhilippeDB[$i]['both_antibio_preceding_date_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_antibio_preceding_date'] != null) || ($listDataFromPhilippeDB[$i]['both_antibio_preceding_date_unknow'] == null && $listDataFromPhilippeDB[$i]['both_antibio_preceding_date'] == null)) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_antibio_preceding_date']);
//                    }
//
//                }
//
//                if (array_key_exists("both_antibio_preceding_date_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_antibio_preceding_date_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_antibio_preceding_date_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_antibio_preceding_date_unknow']);
//                    }
//                }
//                if (array_key_exists("both_frailty_score", $listDataFromPhilippeDB[$i])) {
//                    if ($age && $age >= 50) {
//                        if ((!in_array($listDataFromPhilippeDB[$i]['both_frailty_score'], [1, 2, 3, 4, 5, 6, 7, 8, 9]) && $listDataFromPhilippeDB[$i]['both_frailty_score_unknow'] != 1) || (in_array($listDataFromPhilippeDB[$i]['both_frailty_score'], [1, 2, 3, 4, 5, 6, 7, 8, 9]) && $listDataFromPhilippeDB[$i]['both_frailty_score_unknow'] == 1) || $listDataFromPhilippeDB[$i]['both_frailty_score_unknow'] == null && $listDataFromPhilippeDB[$i]['both_frailty_score'] == null) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_frailty_score']);
//                        }
//                    } else {
//                        if (!in_array($listDataFromPhilippeDB[$i]['both_frailty_score'], [1, 2, 3, 4, 5, 6, 7, 8, 9]) && $listDataFromPhilippeDB[$i]['both_frailty_score'] != null || ($listDataFromPhilippeDB[$i]['both_frailty_score'] != null && $listDataFromPhilippeDB[$i]['both_frailty_score_unknow'] == 1)) {
////                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_frailty_score']);
//                        }
//                    }
//                }
//                if (array_key_exists("both_frailty_score_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_frailty_score_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_frailty_score_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_frailty_score_unknow']);
//                    }
//                }
//                if (array_key_exists("both_severity_confusion", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_severity_confusion'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_severity_confusion']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_severity_confusion'] == null) {
//                        array_push($field, ['field' => 'both_severity_confusion']);
//                    }
//                }
//                if (array_key_exists("both_severity_apnea", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_severity_apnea'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_severity_apnea'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_severity_apnea']);
//                    }
//                }
//                if (array_key_exists("both_discharge_another_hopital", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_discharge_another_hopital'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_discharge_another_hopital']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_discharge_another_hopital'] == null) {
//                        array_push($field, ['field' => 'both_discharge_another_hopital']);
//                    }
//                }
//                if (array_key_exists("both_frailty_score_discharge", $listDataFromPhilippeDB[$i]) && array_key_exists("both_frailty_score_discharge_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($age && $age >= 50) {
//                        if ((!in_array($listDataFromPhilippeDB[$i]['both_frailty_score_discharge'], [1, 2, 3, 4, 5, 6, 7, 8, 9]) && $listDataFromPhilippeDB[$i]['both_frailty_score_discharge_unknow'] != 1) || (in_array($listDataFromPhilippeDB[$i]['both_frailty_score_discharge'], [1, 2, 3, 4, 5, 6, 7, 8, 9]) && $listDataFromPhilippeDB[$i]['both_frailty_score_discharge_unknow'] == 1) || $listDataFromPhilippeDB[$i]['both_frailty_score_discharge_unknow'] == null && $listDataFromPhilippeDB[$i]['both_frailty_score_discharge'] == null) {
////                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_frailty_score_discharge']);
//                        }
//                    } else {
//                        if (!in_array($listDataFromPhilippeDB[$i]['both_frailty_score_discharge'], [1, 2, 3, 4, 5, 6, 7, 8, 9]) && $listDataFromPhilippeDB[$i]['both_frailty_score_discharge'] != null || ($listDataFromPhilippeDB[$i]['both_frailty_score_discharge'] != null && $listDataFromPhilippeDB[$i]['both_frailty_score_discharge_unknow'] == 1)) {
////                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_frailty_score_discharge']);
//                        }
//                    }
//                }
//                if (array_key_exists("both_frailty_score_discharge_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_frailty_score_discharge_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_frailty_score_discharge_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_frailty_score_discharge_unknow']);
//                    }
//                }
//                if (array_key_exists("both_sample_submited", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_sample_submited'], [0, 1, 2])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_sample_submited']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_sample_submited'] == null) {
//                        array_push($field, ['field' => 'both_sample_submited']);
//                    }
//                }
//                //both_display_gisaid
//                if (array_key_exists("both_sample_type", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_sample_type'], [1, 2, 3]) && $listDataFromPhilippeDB[$i]['both_sample_type'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_sample_type']);
//                    }
//                }
//                //both_display_intro
//                //both_display_clinical5bis
//                //both_display_clinical6b
//                if (array_key_exists("both_lab2_corona", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_corona'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_lab2_corona'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_corona']);
//                    }
//                }
//                if (array_key_exists("both_lab2_metaneumo", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_metaneumo'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_lab2_metaneumo'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_metaneumo']);
//                    }
//                }
//                if (array_key_exists("both_lab2_rs", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_rs'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_lab2_rs'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_rs']);
//                    }
//                }
//                if (array_key_exists("both_lab2_adeno", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_adeno'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_lab2_adeno'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_adeno']);
//                    }
//                }
//                if (array_key_exists("both_lab2_boca", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_boca'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_lab2_boca'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_boca']);
//                    }
//                }
//                if (array_key_exists("both_lab2_pi", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_pi'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_lab2_pi'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_pi']);
//                    }
//                }
//                if (array_key_exists("both_lab2_rhino", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_rhino'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_lab2_rhino'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_rhino']);
//                    }
//                }
//                //both_display_hasothersymptoms
//                if (array_key_exists("both_othersymptoms_nausea", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_othersymptoms_nausea'], [0, 1, 2])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_othersymptoms_nausea']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_othersymptoms_nausea'] == null) {
//                        array_push($field, ['field' => 'both_othersymptoms_nausea']);
//                    }
//                }
//                if (array_key_exists("both_othersymptoms_diarrhea", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_othersymptoms_diarrhea'], [0, 1, 2])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_othersymptoms_diarrhea']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_othersymptoms_diarrhea'] == null) {
//                        array_push($field, ['field' => 'both_othersymptoms_diarrhea']);
//                    }
//                }
//                if (array_key_exists("both_othersymptoms_smell", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_othersymptoms_smell'], [0, 1, 2])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_othersymptoms_smell']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_othersymptoms_smell'] == null) {
//                        array_push($field, ['field' => 'both_othersymptoms_smell']);
//                    }
//                }
//                if (array_key_exists("both_othersymptoms_chestpain", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_othersymptoms_chestpain'], [0, 1, 2])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_othersymptoms_chestpain']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_othersymptoms_chestpain'] == null) {
//                        array_push($field, ['field' => 'both_othersymptoms_chestpain']);
//                    }
//                }
//                if (array_key_exists("both_ilirespiratory_wheezing", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_ilirespiratory_wheezing'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_ilirespiratory_wheezing']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_ilirespiratory_wheezing'] == null) {
//                        array_push($field, ['field' => 'both_ilirespiratory_wheezing']);
//                    }
//                }
//
//                if (array_key_exists("both_antibio_during", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_antibio_during'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_antibio_during']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_antibio_during'] == null) {
//                        array_push($field, ['field' => 'both_antibio_during']);
//                    }
//                }
//
//                if (array_key_exists("both_antibio_during_date", $listDataFromPhilippeDB[$i]) && array_key_exists("both_antibio_during_date_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_antibio_during_date_unknow'] == null && $listDataFromPhilippeDB[$i]['both_antibio_during_date'] != null) {
//                        if ((!preg_match("/^([0-9]{2})\/([0-9]{2})\/([0-9]{4})$/", $listDataFromPhilippeDB[$i]['both_antibio_during_date'])) && $listDataFromPhilippeDB[$i]['both_antibio_during_date'] != null) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_antibio_during_date']);
//                        }
//                    } elseif (($listDataFromPhilippeDB[$i]['both_antibio_during_date_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_antibio_during_date'] != null) || ($listDataFromPhilippeDB[$i]['both_antibio_during_date_unknow'] == null && $listDataFromPhilippeDB[$i]['both_antibio_during_date'] == null)) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_antibio_during_date']);
//                    }
//                }
//
//                if (array_key_exists("both_antibio_during_date_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_antibio_during_date_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_antibio_during_date_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_antibio_during_date_unknow']);
//                    }
//                }
//
//                if (array_key_exists("both_antiviral_preceding", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_antiviral_preceding'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_antiviral_preceding']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_antiviral_preceding'] == null) {
//                        array_push($field, ['field' => 'both_antiviral_preceding']);
//                    }
//                }
//
//                if (array_key_exists("both_antiviral_preceding_date", $listDataFromPhilippeDB[$i]) && array_key_exists("both_antiviral_preceding_date_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_antiviral_preceding_date_unknow'] == null && $listDataFromPhilippeDB[$i]['both_antiviral_preceding_date'] != null) {
//                        if ((!preg_match("/^([0-9]{2})\/([0-9]{2})\/([0-9]{4})$/", $listDataFromPhilippeDB[$i]['both_antiviral_preceding_date'])) && $listDataFromPhilippeDB[$i]['both_antiviral_preceding_date'] != null) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_antiviral_preceding_date']);
//                        }
//                    } elseif (($listDataFromPhilippeDB[$i]['both_antiviral_preceding_date_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_antiviral_preceding_date'] != null) || ($listDataFromPhilippeDB[$i]['both_antiviral_preceding_date_unknow'] == null && $listDataFromPhilippeDB[$i]['both_antiviral_preceding_date'] == null)) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_antiviral_preceding_date']);
//                    }
//                }
//
//                if (array_key_exists("both_antiviral_preceding_date_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_antiviral_preceding_date_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_antiviral_preceding_date_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_antiviral_preceding_date_unknow']);
//                    }
//                }
//
//                if (array_key_exists("both_antiviral_during", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_antiviral_during'], [0, 1, 9999])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_antiviral_during']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_antiviral_during'] == null) {
//                        array_push($field, ['field' => 'both_antiviral_during']);
//                    }
//                }
//
//                if (array_key_exists("both_antiviral_during_date", $listDataFromPhilippeDB[$i]) && array_key_exists("both_antiviral_during_date_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_antiviral_during_date_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_antiviral_during_date'] != null) {
//                        if ((!preg_match("/^([0-9]{2})\/([0-9]{2})\/([0-9]{4})$/", $listDataFromPhilippeDB[$i]['both_antiviral_during_date'])) && $listDataFromPhilippeDB[$i]['both_antiviral_during_date'] != null) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_antiviral_during_date']);
//                        }
//                    } elseif (($listDataFromPhilippeDB[$i]['both_antiviral_during_date_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_antiviral_during_date'] != null) || ($listDataFromPhilippeDB[$i]['both_antiviral_during_date_unknow'] == null && $listDataFromPhilippeDB[$i]['both_antiviral_during_date'] == null)) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_antiviral_during_date']);
//                    }
//                }
//
//
//                if (array_key_exists("both_antiviral_during_date_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_antiviral_during_date_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_antiviral_during_date_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_antiviral_during_date_unknow']);
//                    }
//                }
//                if (array_key_exists("both_vac_history_validated", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_vac_history_validated'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_vac_history_validated'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_vac_history_validated']);
//                    }
//                }
//
//                if (array_key_exists("both_lab2_sarscov2", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_sarscov2'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_lab2_sarscov2'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_sarscov2']);
//                    }
//                }
//                if (array_key_exists("both_lab2_sarscov2_yesno", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_sarscov2_yesno'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab2_sarscov2_yesno'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_sarscov2_yesno']);
//                    }
//                }
//                if (array_key_exists("both_lab2_others", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_others'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_lab2_others'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_others']);
//                    }
//                }
//                if (array_key_exists("both_lab2_others_yesno", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_lab2_others_yesno'], [0, 1, 9999]) && $listDataFromPhilippeDB[$i]['both_lab2_others_yesno'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_lab2_others_yesno']);
//                    }
//                }
//                //both_lab2_others_detail
//                if (array_key_exists("both_vac_type_vaccine", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_vac_history_validated'], [9999, 1, 2]) && $listDataFromPhilippeDB[$i]['both_vac_history_validated'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_vac_history_validated']);
//                    }
//                }
//                if (array_key_exists("both_covid_number_doses", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_covid_number_doses'], ['None', 9999, 1, 2, 3])) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_covid_number_doses']);
//                    } elseif ($listDataFromPhilippeDB[$i]['both_covid_number_doses'] == null) {
//                        array_push($field, ['field' => 'both_covid_number_doses']);
//                    }
//                }
//                if (array_key_exists("both_covid_last_dose_date", $listDataFromPhilippeDB[$i]) && array_key_exists("both_covid_last_dose_date_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_covid_last_dose_date_unknow'] == null && $listDataFromPhilippeDB[$i]['both_covid_last_dose_date'] != null) {
//                        if (!preg_match("/^([0-9]{2})\/([0-9]{2})\/([0-9]{4})$/", $listDataFromPhilippeDB[$i]['both_covid_last_dose_date']) && $listDataFromPhilippeDB[$i]['both_covid_last_dose_date'] != null) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_covid_last_dose_date']);
//                        }
//                    } elseif (($listDataFromPhilippeDB[$i]['both_covid_last_dose_date_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_covid_last_dose_date'] != null) || ($listDataFromPhilippeDB[$i]['both_covid_last_dose_date_unknow'] == null && $listDataFromPhilippeDB[$i]['both_covid_last_dose_date'] == null)) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_covid_last_dose_date']);
//                    }
//                }
//
//                if (array_key_exists("both_covid_last_dose_date_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_covid_last_dose_date_unknow'] != 1 && $listDataFromPhilippeDB[$i]['both_covid_last_dose_date_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_covid_last_dose_date_unknow']);
//                    }
//                }
//
//                if (array_key_exists("both_covid_vaccine_mrna", $listDataFromPhilippeDB[$i]) && array_key_exists("both_covid_vaccine_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_covid_vaccine_unknow'] == null && $listDataFromPhilippeDB[$i]['both_covid_vaccine_mrna'] != null) {
//                        if (!in_array($listDataFromPhilippeDB[$i]['both_covid_vaccine_mrna'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_covid_vaccine_mrna'] != null) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_covid_vaccine_mrna']);
//                        }
//                    } elseif (($listDataFromPhilippeDB[$i]['both_covid_vaccine_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_covid_vaccine_mrna'] != null) || ($listDataFromPhilippeDB[$i]['both_covid_vaccine_unknow'] == null && $listDataFromPhilippeDB[$i]['both_covid_vaccine_mrna'] == null)) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_covid_vaccine_mrna']);
//                    }
//                }
//                if (array_key_exists("both_covid_vaccine_inactivated_virion", $listDataFromPhilippeDB[$i]) && array_key_exists("both_covid_vaccine_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_covid_vaccine_unknow'] == null && $listDataFromPhilippeDB[$i]['both_covid_vaccine_inactivated_virion'] != null) {
//                        if (!in_array($listDataFromPhilippeDB[$i]['both_covid_vaccine_inactivated_virion'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_covid_vaccine_inactivated_virion'] != null) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_covid_vaccine_inactivated_virion']);
//                        }
//                    } elseif (($listDataFromPhilippeDB[$i]['both_covid_vaccine_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_covid_vaccine_inactivated_virion'] != null) || ($listDataFromPhilippeDB[$i]['both_covid_vaccine_unknow'] == null && $listDataFromPhilippeDB[$i]['both_covid_vaccine_inactivated_virion'] == null)) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_covid_vaccine_inactivated_virion']);
//                    }
//                }
//                if (array_key_exists("both_covid_vaccine_viral_vector", $listDataFromPhilippeDB[$i]) && array_key_exists("both_covid_vaccine_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_covid_vaccine_unknow'] == null && $listDataFromPhilippeDB[$i]['both_covid_vaccine_viral_vector'] != null) {
//                        if (!in_array($listDataFromPhilippeDB[$i]['both_covid_vaccine_viral_vector'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_covid_vaccine_viral_vector'] != null) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_covid_vaccine_viral_vector']);
//                        }
//                    } elseif (($listDataFromPhilippeDB[$i]['both_covid_vaccine_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_covid_vaccine_viral_vector'] != null) || ($listDataFromPhilippeDB[$i]['both_covid_vaccine_unknow'] == null && $listDataFromPhilippeDB[$i]['both_covid_vaccine_viral_vector'] == null)) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_covid_vaccine_viral_vector']);
//                    }
//                }
//                if (array_key_exists("both_covid_vaccine_protein_subunit", $listDataFromPhilippeDB[$i]) && array_key_exists("both_covid_vaccine_unknow", $listDataFromPhilippeDB[$i])) {
//                    if ($listDataFromPhilippeDB[$i]['both_covid_vaccine_unknow'] == null && $listDataFromPhilippeDB[$i]['both_covid_vaccine_protein_subunit'] != null) {
//                        if (!in_array($listDataFromPhilippeDB[$i]['both_covid_vaccine_protein_subunit'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_covid_vaccine_protein_subunit'] != null) {
//                            // $importDBPhilippe = false;
//                            array_push($field, ['field' => 'both_covid_vaccine_protein_subunit']);
//                        }
//                    } elseif (($listDataFromPhilippeDB[$i]['both_covid_vaccine_unknow'] == 1 && $listDataFromPhilippeDB[$i]['both_covid_vaccine_protein_subunit'] != null) || ($listDataFromPhilippeDB[$i]['both_covid_vaccine_unknow'] == null && $listDataFromPhilippeDB[$i]['both_covid_vaccine_protein_subunit'] == null)) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_covid_vaccine_protein_subunit']);
//                    }
//                }
//
//
//                if (array_key_exists("both_covid_vaccine_unknow", $listDataFromPhilippeDB[$i])) {
//                    if (!in_array($listDataFromPhilippeDB[$i]['both_covid_vaccine_unknow'], [0, 1]) && $listDataFromPhilippeDB[$i]['both_covid_vaccine_unknow'] != null) {
//                        // $importDBPhilippe = false;
//                        array_push($field, ['field' => 'both_covid_vaccine_unknow']);
//                    }
//                }
//
//
//                // check the result of each line we will import it, if the $field array is not empty we move the line to the excel file and import it into the database
//                if (count($field) > 0) {
//                    array_push($wrongFieldsInDBPhilippe, ['id_philippe' => $listDataFromPhilippeDB[$i]['id_bdd_philippe'], 'fields' => $field]);
//                }
//                // verify if the "$importDBPhilippe is true " thats mean the site_id is exist in our base in the table site so we gonna insert
//                // if the line is new or we gonna update it his information if the line exist
//                if ($importDBPhilippe) {
//                    $sqlCount = $this->conn->fetchAll('SELECT COUNT(id) AS nb FROM `data` WHERE id_bdd_philippe = "' . $listDataFromPhilippeDB[$i]['id_bdd_philippe'] . '" AND site_id = "' . $listDataFromPhilippeDB[$i]['site_id'] . '"');
//                    if ($sqlCount[0]['nb'] == 0) {
//                        try {
//                            $this->conn->insert("data", $listDataFromPhilippeDB[$i]);
//                        } catch (\Exception $e) {
//                            echo $e->getMessage();
//                            exit;
//                        }
//                    } else {
//                        try {
//                            $this->conn->update("data", $listDataFromPhilippeDB[$i], [
//                                'id_bdd_philippe' => $listDataFromPhilippeDB[$i]['id_bdd_philippe'],
//                                'site_id' => $listDataFromPhilippeDB[$i]['site_id']
//                            ]);
//                        } catch (\Exception $e) {
//                            echo $e->getMessage();
//                            exit;
//                        }
//                    }
//                }
//            }
//        }
//
//        $this->forward("App\Controller\VariableController::runSQLAction")->getContent();
//
//        // return as result the list of lines in DB PHILLIPPE which are incorrect
//        return $wrongFieldsInDBPhilippe;
//    }

    /**
     * @Route("/importPortail/cron", name="import_portail")
     */
    public function importPortail(): Response
    {
        try {
            ini_set("max-execution_time", 0);
            ini_set('memory_limit', '-1');
            set_time_limit(7200);

            $nbDeletedRows = 0;
            $nbLines = 0;

            /*** get sites entries (consommer api survey) ***/
            $fetchSitesResponse = $this->gihsnWpApiService->fetchSites();
            if ($fetchSitesResponse['error'] != '') {
                return new Response("<html><body>" . $fetchSitesResponse['error'] . "  </body></html>");
            }
            $nbSites = $this->postSites($fetchSitesResponse['sites']);

            /*** get survey entries (consommer api survey) ***/
            $fetchEntriesResponse = $this->gihsnWpApiService->fetchEntries();

            if ($fetchEntriesResponse['error'] != '') {
                return new Response("<html><body>" . $fetchEntriesResponse['error'] . "  </body></html>");
            }
            $entries = $fetchEntriesResponse['entries'];

            /**  Ajouter ou modifier data */
            foreach ($entries as $entry) {
                $nbLines++;
                $entryId = $entry['id'];
                //check entry is exist or not in db
                $data = $this->em->getRepository(data::class)->findOneBy(['idWp' => $entryId]);
                if (!$data) {
                    $data = new Data();
                }

                if ($data->getPriority() != 1 && $data->getIsValidated() != 1) {
                    $this->postEntryToData($entry['meta'], $entryId, $entry['created_at'], $entry['updated_at'], $entry['updated_by'], $entry['is_draft'], $data);
                }
            }
            $this->em->flush();

            /** Suppression des entrées de la base de données Symfony qui ont été supprimées de WordPress */
            // récuperer tous les ids de demandes de wordpress
            $fetchEntriesIdsResponse = $this->gihsnWpApiService->fetchEntriesIds();
            if ($fetchEntriesIdsResponse['error'] != '') {
                return new Response("<html><body> suppressrion data: " . $fetchEntriesIdsResponse['error'] . "  </body></html>");
            }
            $entriesIds = json_decode($fetchEntriesIdsResponse['ids'], true);
            if (count($entriesIds) > 0) {
                // Supprimer de la table 'data' les demandes de sondage qui ont des id 'id_wp' qui n'existent pas dans le résultat 'entriesIds'
                $nbDeletedRows = $this->em->getRepository(Data::class)->removeListData($entriesIds);
            }

            //calculate
            $this->forward("App\Controller\VariableController::runSQLAction")->getContent();

            return new Response("<html><body>
                        Import base de données portail terminé : Nombre d'entries ajoutés/modifiés $nbLines <br />
                        Nombre de sites ajoutés/modifiés $nbSites<br/>
                        Suppression des entrées de la base de données Symfony qui ont été supprimées de WordPress : Nombre d'entries supprimés $nbDeletedRows<br/>
                        </body></html>");
        } catch (Exception $ex) {
            return new Response("<html><body>" . $ex->getMessage() . "</body></html>");
        }
    }

    /* cette méthode sert à ajouter ou modifier data (entry) */
    public function postEntryToData($entryMeta, $entryId, $createdDate, $updateDate, $updatedBy, $isDraft, $data)
    {
        $data->setIdWp($entryId);

        if (array_key_exists("both_site_id", $entryMeta) && $entryMeta["both_site_id"] != "") {
            $site = $this->em->getRepository(Site::class)->find($entryMeta["both_site_id"]);
            if ($site) {
                $data->setSite($site);
            } else {
                $data->setSite(null);
            }
        }

        if (array_key_exists("both_id_patient", $entryMeta)) {
            $data->setBothIdPatient($entryMeta["both_id_patient"]);
        } else {
            $data->setBothIdPatient(null);
        }

        if (array_key_exists("season", $entryMeta)) {
            $data->setSeason($entryMeta["season"]);
        } else {
            $data->setSeason($this->calculerSaison($createdDate));
        }

        if (array_key_exists("both_age", $entryMeta)) {
            $data->setBothage($entryMeta["both_age"]);
        } else {
            $data->setBothage(null);
        }

        if (array_key_exists("both_age_unit", $entryMeta)) {
            $data->setBothageunit($entryMeta["both_age_unit"]);
        } else {
            $data->setBothageunit(null);
        }

        if (array_key_exists("both_doa", $entryMeta)) {
            $bothDoa = $this->formateDate($entryMeta["both_doa"]);
            $data->setBothDoa($bothDoa);
            $bothDoaDate = \DateTime::createFromFormat('d/m/Y', $bothDoa);
            if ($bothDoaDate) {
                $weekYear = $bothDoaDate->format("W--o");
                $data->setWeekNumber($weekYear);
            }
        } else {
            $data->setBothDoa(null);
        }

        $data->setDateLastModified($updateDate);
        $data->setIdLastModificator($updatedBy);

        if (array_key_exists("user-modify-survey", $entryMeta)) {
            $data->setNameLastModificator($entryMeta["user-modify-survey"]);
        } else {
            $data->setNameLastModificator(null);
        }

        if ($isDraft == 1) {
            $data->setIsValidated(0);
        } else {
            $data->setIsValidated(1);
        }

        if (array_key_exists("both_comp_a_diag", $entryMeta)) {
            $data->setBothCompADiag($entryMeta["both_comp_a_diag"]);
        } else {
            $data->setBothCompADiag(null);
        }

        if (array_key_exists("both_id_hospital", $entryMeta)) {
            $data->setBothIdHospital($entryMeta["both_id_hospital"]);
        } else {
            $data->setBothIdHospital(null);
        }

        if (array_key_exists("both_sex", $entryMeta)) {
            $data->setBothSex($entryMeta["both_sex"]);
        } else {
            $data->setBothSex(null);
        }

        if (array_key_exists("both_chronic_cond_yn", $entryMeta)) {
            $data->setBothChronicCondYn($entryMeta["both_chronic_cond_yn"]);
        } else {
            $data->setBothChronicCondYn(null);
        }

        if (array_key_exists("both_display_clinical3", $entryMeta)) {
            $data->setBothDisplayClinical3($entryMeta["both_display_clinical3"]);
        } else {
            $data->setBothDisplayClinical3(null);
        }

        if (array_key_exists("both_chronic_cvd_blood", $entryMeta)) {
            $data->setBothChronicCvdBlood($entryMeta["both_chronic_cvd_blood"]);
        } else {
            $data->setBothChronicCvdBlood(null);
        }

        if (array_key_exists("both_chronic_copd", $entryMeta)) {
            $data->setBothChronicCopd($entryMeta["both_chronic_copd"]);
        } else {
            $data->setBothChronicCopd(null);
        }

        if (array_key_exists("both_chronic_asthma", $entryMeta)) {
            $data->setBothChronicAsthma($entryMeta["both_chronic_asthma"]);
        } else {
            $data->setBothChronicAsthma(null);
        }

        if (array_key_exists("both_chronic_diabetes", $entryMeta)) {
            $data->setBothChronicDiabetes($entryMeta["both_chronic_diabetes"]);
        } else {
            $data->setBothChronicDiabetes(null);
        }

        if (array_key_exists("both_chronic_immuno", $entryMeta)) {
            $data->setBothChronicImmuno($entryMeta["both_chronic_immuno"]);
        } else {
            $data->setBothChronicImmuno(null);
        }

        if (array_key_exists("both_chronic_renal", $entryMeta)) {
            $data->setBothChronicRenal($entryMeta["both_chronic_renal"]);
        } else {
            $data->setBothChronicRenal(null);
        }

        if (array_key_exists("both_chronic_rheumatologic_autoimmune_dis", $entryMeta)) {
            $data->setBothChronicRheumatologicAutoimmuneDis($entryMeta["both_chronic_rheumatologic_autoimmune_dis"]);
        } else {
            $data->setBothChronicRheumatologicAutoimmuneDis(null);
        }

        if (array_key_exists("both_chronic_neurological_neuromuscular_dis", $entryMeta)) {
            $data->setBothChronicNeurologicalNeuromuscularDis($entryMeta["both_chronic_neurological_neuromuscular_dis"]);
        } else {
            $data->setBothChronicNeurologicalNeuromuscularDis(null);
        }

        if (array_key_exists("both_chronic_cirrhosis_liver_dis", $entryMeta)) {
            $data->setBothChronicCirrhosisLiverDis($entryMeta["both_chronic_cirrhosis_liver_dis"]);
        } else {
            $data->setBothChronicCirrhosisLiverDis(null);
        }

        if (array_key_exists("both_chronic_neoplasm", $entryMeta)) {
            $data->setBothChronicNeoplasm($entryMeta["both_chronic_neoplasm"]);
        } else {
            $data->setBothChronicNeoplasm(null);
        }

        if (array_key_exists("both_chronic_obesity", $entryMeta)) {
            $data->setBothChronicObesity($entryMeta["both_chronic_obesity"]);
        } else {
            $data->setBothChronicObesity(null);
        }

        if (array_key_exists("both_chronic_malnutri", $entryMeta)) {
            $data->setBothChronicMalnutri($entryMeta["both_chronic_malnutri"]);
        } else {
            $data->setBothChronicMalnutri(null);
        }

        if (array_key_exists("both_chronic_active_tuberculosis", $entryMeta)) {
            $data->setBothChronicActiveTuberculosis($entryMeta["both_chronic_active_tuberculosis"]);
        } else {
            $data->setBothChronicActiveTuberculosis(null);
        }

        if (array_key_exists("both_chronic_hiv_infection", $entryMeta)) {
            $data->setBothChronicHivInfection($entryMeta["both_chronic_hiv_infection"]);
        } else {
            $data->setBothChronicHivInfection(null);
        }

        if (array_key_exists("both_chronic_hiv_exposure", $entryMeta)) {
            $data->setBothChronicHivExposure($entryMeta["both_chronic_hiv_exposure"]);
        } else {
            $data->setBothChronicHivExposure(null);
        }

        if (array_key_exists("both_chronic_other", $entryMeta)) {
            $data->setBothChronicOther($entryMeta["both_chronic_other"]);
        } else {
            $data->setBothChronicOther(null);
        }

        if (array_key_exists("both_influ_vac_current_season", $entryMeta)) {
            $data->setBothInfluVacCurrentSeason($entryMeta["both_influ_vac_current_season"]);
        } else {
            $data->setBothInfluVacCurrentSeason(null);
        }

        if (array_key_exists("both_vac_14d_before_ili_sym", $entryMeta)) {
            $data->setBothVac14dBeforeIliSym($entryMeta["both_vac_14d_before_ili_sym"]);
        } else {
            $data->setBothVac14dBeforeIliSym(null);
        }

        if (array_key_exists("both_vac_preceding_season", $entryMeta)) {
            $data->setBothVacPrecedingSeason($entryMeta["both_vac_preceding_season"]);
        } else {
            $data->setBothVacPrecedingSeason(null);
        }

        if (array_key_exists("both_swab_date", $entryMeta)) {
            $data->setBothSwabDate($this->formateDate($entryMeta["both_swab_date"]));
        } else {
            $data->setBothSwabDate(null);
        }

        if (array_key_exists("both_swab_date_unknow", $entryMeta)) {
            $data->setBothSwabDateUnknow($entryMeta["both_swab_date_unknow"]);
        } else {
            $data->setBothSwabDateUnknow(null);
        }

        if (array_key_exists("both_severity_oxygen_saturation", $entryMeta)) {
            $data->setBothSeverityOxygenSaturation($entryMeta["both_severity_oxygen_saturation"]);
        } else {
            $data->setBothSeverityOxygenSaturation(null);
        }

        if (array_key_exists("both_severity_oxygen_saturation_unknow", $entryMeta)) {
            $data->setBothSeverityOxygenSaturationUnknow($entryMeta["both_severity_oxygen_saturation_unknow"]);
        } else {
            $data->setBothSeverityOxygenSaturationUnknow(null);
        }

        if (array_key_exists("both_severity_respiration_rate", $entryMeta)) {
            $data->setBothSeverityRespirationRate($entryMeta["both_severity_respiration_rate"]);
        } else {
            $data->setBothSeverityRespirationRate(null);
        }

        if (array_key_exists("both_severity_respiration_rate_unknow", $entryMeta)) {
            $data->setBothSeverityRespirationRateUnknow($entryMeta["both_severity_respiration_rate_unknow"]);
        } else {
            $data->setBothSeverityRespirationRateUnknow(null);
        }

        if (array_key_exists("both_severity_supp_oxygen", $entryMeta)) {
            $data->setBothSeveritySuppOxygen($entryMeta["both_severity_supp_oxygen"]);
        } else {
            $data->setBothSeveritySuppOxygen(null);
        }

        if (array_key_exists("both_severity_vaso_support", $entryMeta)) {
            $data->setBothSeverityVasoSupport($entryMeta["both_severity_vaso_support"]);
        } else {
            $data->setBothSeverityVasoSupport(null);
        }

        if (array_key_exists("both_icu_adm", $entryMeta)) {
            $data->setBothIcuAdm($entryMeta["both_icu_adm"]);
        } else {
            $data->setBothIcuAdm(null);
        }

        if (array_key_exists("both_death_hosp", $entryMeta)) {
            $data->setBothDeathHosp($entryMeta["both_death_hosp"]);
        } else {
            $data->setBothDeathHosp(null);
        }

        if (array_key_exists("both_severity_mech_vent", $entryMeta)) {
            $data->setBothSeverityMechVent($entryMeta["both_severity_mech_vent"]);
        } else {
            $data->setBothSeverityMechVent(null);
        }

        if (array_key_exists("both_discharged_date", $entryMeta)) {
            $data->setBothDischargedDate($this->formateDate($entryMeta["both_discharged_date"]));
        } else {
            $data->setBothDischargedDate(null);
        }

        if (array_key_exists("both_d_diag1", $entryMeta)) {
            $data->setBothDDiag1($entryMeta["both_d_diag1"]);
        } else {
            $data->setBothDDiag1(null);
        }

        if (array_key_exists("both_d_diag2", $entryMeta)) {
            $data->setBothDDiag2($entryMeta["both_d_diag2"]);
        } else {
            $data->setBothDDiag2(null);
        }

        if (array_key_exists("both_d_diag3", $entryMeta)) {
            $data->setBothDDiag3($entryMeta["both_d_diag3"]);
        } else {
            $data->setBothDDiag3(null);
        }

        if (array_key_exists("both_d_icd", $entryMeta)) {
            $data->setBothDIcd($entryMeta["both_d_icd"]);
        } else {
            $data->setBothDIcd(null);
        }

        if (array_key_exists("both_positive_result", $entryMeta)) {
            $data->setBothPositiveResult($entryMeta["both_positive_result"]);
        } else {
            $data->setBothPositiveResult(null);
        }

        if (array_key_exists("both_display_labo2", $entryMeta)) {
            $data->setBothDisplayLabo2($entryMeta["both_display_labo2"]);
        } else {
            $data->setBothDisplayLabo2(null);
        }

        if (array_key_exists("both_lab_flu_h1n1", $entryMeta)) {
            $data->setBothLabFluH1n1($entryMeta["both_lab_flu_h1n1"]);
        } else {
            $data->setBothLabFluH1n1("0");
        }

        if (array_key_exists("both_lab_flu_h3n2", $entryMeta)) {
            $data->setBothLabFluH3n2($entryMeta["both_lab_flu_h3n2"]);
        } else {
            $data->setBothLabFluH3n2("0");
        }

        if (array_key_exists("both_lab_flu_yamagata", $entryMeta)) {
            $data->setBothLabFluYamagata($entryMeta["both_lab_flu_yamagata"]);
        } else {
            $data->setBothLabFluYamagata("0");
        }

        if (array_key_exists("both_lab_flu_victoria", $entryMeta)) {
            $data->setBothLabFluVictoria($entryMeta["both_lab_flu_victoria"]);
        } else {
            $data->setBothLabFluVictoria("0");
        }

        if (array_key_exists("both_lab_flu_h1nother", $entryMeta)) {
            $data->setBothLabFluH1Nother($entryMeta["both_lab_flu_h1nother"]);
        } else {
            $data->setBothLabFluH1Nother("0");
        }

        if (array_key_exists("both_lab_flu_h3nother", $entryMeta)) {
            $data->setBothLabFluH3Nother($entryMeta["both_lab_flu_h3nother"]);
        } else {
            $data->setBothLabFluH3Nother("0");
        }

        if (array_key_exists("both_lab_flu_a_nosub", $entryMeta)) {
            $data->setBothLabFluANosub($entryMeta["both_lab_flu_a_nosub"]);
        } else {
            $data->setBothLabFluANosub("0");
        }

        if (array_key_exists("both_lab_flu_b_nosub", $entryMeta)) {
            $data->setBothLabFluBNosub($entryMeta["both_lab_flu_b_nosub"]);
        } else {
            $data->setBothLabFluBNosub("0");
        }

        if (array_key_exists("both_lab2_corona_yesno", $entryMeta)) {
            $data->setBothLab2CoronaYesno($entryMeta["both_lab2_corona_yesno"]);
        } else {
            $data->setBothLab2CoronaYesno(null);
        }

        if (array_key_exists("both_lab2_metaneumo_yesno", $entryMeta)) {
            $data->setBothLab2MetaneumoYesno($entryMeta["both_lab2_metaneumo_yesno"]);
        } else {
            $data->setBothLab2MetaneumoYesno(null);
        }

        if (array_key_exists("both_lab2_rs_yesno", $entryMeta)) {
            $data->setBothLab2RsYesno($entryMeta["both_lab2_rs_yesno"]);
        } else {
            $data->setBothLab2RsYesno(null);
        }

        if (array_key_exists("both_lab2_adeno_yesno", $entryMeta)) {
            $data->setBothLab2AdenoYesno($entryMeta["both_lab2_adeno_yesno"]);
        } else {
            $data->setBothLab2AdenoYesno(null);
        }

        if (array_key_exists("both_lab2_boca_yesno", $entryMeta)) {
            $data->setBothLab2BocaYesno($entryMeta["both_lab2_boca_yesno"]);
        } else {
            $data->setBothLab2BocaYesno(null);
        }

        if (array_key_exists("both_lab2_pi_yesno", $entryMeta)) {
            $data->setBothLab2PiYesno($entryMeta["both_lab2_pi_yesno"]);
        } else {
            $data->setBothLab2PiYesno(null);
        }

        if (array_key_exists("both_lab2_rhino_yesno", $entryMeta)) {
            $data->setBothLab2RhinoYesno($entryMeta["both_lab2_rhino_yesno"]);
        } else {
            $data->setBothLab2RhinoYesno(null);
        }

        // both_display_ilisystemic: field de type html => toujours null

        if (array_key_exists("both_ilisystemic_fever", $entryMeta)) {
            $data->setBothIlisystemicFever($entryMeta["both_ilisystemic_fever"]);
        } else {
            $data->setBothIlisystemicFever(null);
        }

        if (array_key_exists("both_ilisystemic_malaise", $entryMeta)) {
            $data->setBothIlisystemicMalaise($entryMeta["both_ilisystemic_malaise"]);
        } else {
            $data->setBothIlisystemicMalaise(null);
        }

        if (array_key_exists("both_ilisystemic_headache", $entryMeta)) {
            $data->setBothIlisystemicHeadache($entryMeta["both_ilisystemic_headache"]);
        } else {
            $data->setBothIlisystemicHeadache(null);
        }

        if (array_key_exists("both_ilisystemic_myalgia", $entryMeta)) {
            $data->setBothIlisystemicMyalgia($entryMeta["both_ilisystemic_myalgia"]);
        } else {
            $data->setBothIlisystemicMyalgia(null);
        }

        if (array_key_exists("both_ilirespiratory_cough", $entryMeta)) {
            $data->setBothIlirespiratoryCough($entryMeta["both_ilirespiratory_cough"]);
        } else {
            $data->setBothIlirespiratoryCough(null);
        }

        if (array_key_exists("both_ilirespiratory_sorethroat", $entryMeta)) {
            $data->setBothIlirespiratorySorethroat($entryMeta["both_ilirespiratory_sorethroat"]);
        } else {
            $data->setBothIlirespiratorySorethroat(null);
        }

        if (array_key_exists("both_ilirespiratory_shortnessbreath", $entryMeta)) {
            $data->setBothIlirespiratoryShortnessbreath($entryMeta["both_ilirespiratory_shortnessbreath"]);
        } else {
            $data->setBothIlirespiratoryShortnessbreath(null);
        }

        // both_display_ilirespiratory: field de type html => toujours null

        if (array_key_exists("both_ilirespiratory_nasalcongestion", $entryMeta)) {
            $data->setBothIlirespiratoryNasalcongestion($entryMeta["both_ilirespiratory_nasalcongestion"]);
        } else {
            $data->setBothIlirespiratoryNasalcongestion(null);
        }

        // both_display_clinical2: field de type html => toujours null

        // both_display_clinical4: field de type html => toujours null

        // both_display_clinical5: field de type html => toujours null

        // both_display_clinical6: field de type html => toujours null

        // both_display_clinical7: field de type html => toujours null

        if (array_key_exists("both_pregnancy_status", $entryMeta)) {
            $data->setBothPregnancyStatus($entryMeta["both_pregnancy_status"]);
        } else {
            $data->setBothPregnancyStatus(null);
        }

        if (array_key_exists("both_pregnancy_weeks", $entryMeta)) {
            $data->setBothPregnancyWeeks($entryMeta["both_pregnancy_weeks"]);
        } else {
            $data->setBothPregnancyWeeks(null);
        }

        if (array_key_exists("both_pregnancy_weeks_unknow", $entryMeta)) {
            $data->setBothPregnancyWeeksUnknow($entryMeta["both_pregnancy_weeks_unknow"]);
        } else {
            $data->setBothPregnancyWeeksUnknow(null);
        }

        //both_display_hasonesymptoms: field de type html => toujours null

        if (array_key_exists("both_test_other_virus", $entryMeta)) {
            $data->setBothTestOtherVirus($entryMeta["both_test_other_virus"]);
        } else {
            $data->setBothTestOtherVirus(null);
        }

        if (array_key_exists("both_display_test_other2", $entryMeta)) {
            $data->setBothDisplayTestOther2($entryMeta["both_display_test_other2"]);
        } else {
            $data->setBothDisplayTestOther2(null);
        }

        //display_titre_labo: field de type html => toujours null

        if (array_key_exists("both_height", $entryMeta)) {
            $data->setBothHeight($entryMeta["both_height"]);
        } else {
            $data->setBothHeight(null);
        }

        if (array_key_exists("both_weight", $entryMeta)) {
            $data->setBothWeight($entryMeta["both_weight"]);
        } else {
            $data->setBothWeight(null);
        }

        if (array_key_exists("both_height_unknow", $entryMeta)) {
            $data->setBothHeightUnknow($entryMeta["both_height_unknow"]);
        } else {
            $data->setBothHeightUnknow(null);
        }

        if (array_key_exists("both_weight_unknow", $entryMeta)) {
            $data->setBothWeightUnknow($entryMeta["both_weight_unknow"]);
        } else {
            $data->setBothWeightUnknow(null);
        }

        if (array_key_exists("both_chronic_prematurity", $entryMeta)) {
            $data->setBothChronicPrematurity($entryMeta["both_chronic_prematurity"]);
        } else {
            $data->setBothChronicPrematurity(null);
        }

        if (array_key_exists("both_chronic_hemoglobinopathies", $entryMeta)) {
            $data->setBothChronicHemoglobinopathies($entryMeta["both_chronic_hemoglobinopathies"]);
        } else {
            $data->setBothChronicHemoglobinopathies(null);
        }

        if (array_key_exists("both_antibio_preceding", $entryMeta)) {
            $data->setBothAntibioPreceding($entryMeta["both_antibio_preceding"]);
        } else {
            $data->setBothAntibioPreceding(null);
        }

        if (array_key_exists("both_antibio_preceding_date", $entryMeta)) {
            $data->setBothAntibioPrecedingDate($this->formateDate($entryMeta["both_antibio_preceding_date"]));
        } else {
            $data->setBothAntibioPrecedingDate(null);
        }

        if (array_key_exists("both_frailty_score", $entryMeta)) {
            $data->setBothFrailtyScore($entryMeta["both_frailty_score"]);
        } else {
            $data->setBothFrailtyScore(null);
        }

        if (array_key_exists("both_frailty_score_unknow", $entryMeta)) {
            $data->setBothFrailtyScoreUnknow($entryMeta["both_frailty_score_unknow"]);
        } else {
            $data->setBothFrailtyScoreUnknow(null);
        }

        if (array_key_exists("both_severity_confusion", $entryMeta)) {
            $data->setBothSeverityConfusion($entryMeta["both_severity_confusion"]);
        } else {
            $data->setBothSeverityConfusion(null);
        }

        if (array_key_exists("both_severity_apnea", $entryMeta)) {
            $data->setBothSeverityApnea($entryMeta["both_severity_apnea"]);
        } else {
            $data->setBothSeverityApnea(null);
        }

        if (array_key_exists("both_discharge_another_hopital", $entryMeta)) {
            $data->setBothDischargeAnotherHopital($entryMeta["both_discharge_another_hopital"]);
        } else {
            $data->setBothDischargeAnotherHopital(null);
        }

        if (array_key_exists("both_frailty_score_discharge", $entryMeta)) {
            $data->setBothFrailtyScoreDischarge($entryMeta["both_frailty_score_discharge"]);
        } else {
            $data->setBothFrailtyScoreDischarge(null);
        }

        if (array_key_exists("both_frailty_score_discharge_unknow", $entryMeta)) {
            $data->setBothFrailtyScoreDischargeUnknow($entryMeta["both_frailty_score_discharge_unknow"]);
        } else {
            $data->setBothFrailtyScoreDischargeUnknow(null);
        }

        if (array_key_exists("both_sample_submited", $entryMeta)) {
            $data->setBothSampleSubmited($entryMeta["both_sample_submited"]);
        } else {
            $data->setBothSampleSubmited("0");
        }

        if (array_key_exists("both_sample_submited_influenza", $entryMeta)) {
            $data->setBothSampleSubmitedInfluenza($entryMeta["both_sample_submited_influenza"]);
        } else {
            $data->setBothSampleSubmitedInfluenza("0");
        }

        if (array_key_exists("both_epi_isl_influenza", $entryMeta)) {
            $data->setBothEpiIslInfluenza($entryMeta["both_epi_isl_influenza"]);
        } else {
            $data->setBothEpiIslInfluenza(null);
        }

        if (array_key_exists("both_sample_submited_sars-cov2", $entryMeta)) {
            $data->setBothSampleSubmitedSarsCov2($entryMeta["both_sample_submited_sars-cov2"]);
        } else {
            $data->setBothSampleSubmitedSarsCov2("0");
        }

        if (array_key_exists("both_epi_isl_sars-cov2", $entryMeta)) {
            $data->setBothEpiIslSarsCov2($entryMeta["both_epi_isl_sars-cov2"]);
        } else {
            $data->setBothEpiIslSarsCov2(null);
        }

        if (array_key_exists("both_sample_submited_rsv", $entryMeta)) {
            $data->setBothSampleSubmitedRsv($entryMeta["both_sample_submited_rsv"]);
        } else {
            $data->setBothSampleSubmitedRsv("0");
        }

        if (array_key_exists("both_epi_isl_rsv", $entryMeta)) {
            $data->setBothEpiIslRsv($entryMeta["both_epi_isl_rsv"]);
        } else {
            $data->setBothEpiIslRsv(null);
        }

        //both_display_gisaid: field de type html => toujours null

        //both_display_clinical6b: field de type html => toujours null

        if (array_key_exists("both_lab2_corona", $entryMeta)) {
            $data->setBothLab2Corona($entryMeta["both_lab2_corona"]);
        } else {
            $data->setBothLab2Corona("0");
        }

        if (array_key_exists("both_lab2_metaneumo", $entryMeta)) {
            $data->setBothLab2Metaneumo($entryMeta["both_lab2_metaneumo"]);
        } else {
            $data->setBothLab2Metaneumo("0");
        }

        if (array_key_exists("both_lab2_rs", $entryMeta)) {
            $data->setBothLab2Rs($entryMeta["both_lab2_rs"]);
        } else {
            $data->setBothLab2Rs("0");
        }

        if (array_key_exists("both_lab2_adeno", $entryMeta)) {
            $data->setBothLab2Adeno($entryMeta["both_lab2_adeno"]);
        } else {
            $data->setBothLab2Adeno("0");
        }

        if (array_key_exists("both_lab2_boca", $entryMeta)) {
            $data->setBothLab2Boca($entryMeta["both_lab2_boca"]);
        } else {
            $data->setBothLab2Boca("0");
        }

        if (array_key_exists("both_lab2_pi", $entryMeta)) {
            $data->setBothLab2Pi($entryMeta["both_lab2_pi"]);
        } else {
            $data->setBothLab2Pi("0");
        }

        if (array_key_exists("both_lab2_rhino", $entryMeta)) {
            $data->setBothLab2Rhino($entryMeta["both_lab2_rhino"]);
        } else {
            $data->setBothLab2Rhino("0");
        }

        //both_display_hasothersymptoms: field de type html => toujours null

        if (array_key_exists("both_othersymptoms_nausea", $entryMeta)) {
            $data->setBothOthersymptomsNausea($entryMeta["both_othersymptoms_nausea"]);
        } else {
            $data->setBothOthersymptomsNausea(null);
        }

        if (array_key_exists("both_othersymptoms_diarrhea", $entryMeta)) {
            $data->setBothOthersymptomsDiarrhea($entryMeta["both_othersymptoms_diarrhea"]);
        } else {
            $data->setBothOthersymptomsDiarrhea(null);
        }

        if (array_key_exists("both_othersymptoms_smell", $entryMeta)) {
            $data->setBothOthersymptomsSmell($entryMeta["both_othersymptoms_smell"]);
        } else {
            $data->setBothOthersymptomsSmell(null);
        }

        if (array_key_exists("both_othersymptoms_chestpain", $entryMeta)) {
            $data->setBothOthersymptomsChestpain($entryMeta["both_othersymptoms_chestpain"]);
        } else {
            $data->setBothOthersymptomsChestpain(null);
        }

        if (array_key_exists("both_ilirespiratory_wheezing", $entryMeta)) {
            $data->setBothIlirespiratoryWheezing($entryMeta["both_ilirespiratory_wheezing"]);
        } else {
            $data->setBothIlirespiratoryWheezing(null);
        }

        if (array_key_exists("both_antibio_during", $entryMeta)) {
            $data->setBothAntibioDuring($entryMeta["both_antibio_during"]);
        } else {
            $data->setBothAntibioDuring(null);
        }

        if (array_key_exists("both_antibio_during_date", $entryMeta)) {
            $data->setBothAntibioDuringDate($this->formateDate($entryMeta["both_antibio_during_date"]));
        } else {
            $data->setBothAntibioDuringDate(null);
        }

        if (array_key_exists("both_antiviral_preceding", $entryMeta)) {
            $data->setBothAntiviralPreceding($entryMeta["both_antiviral_preceding"]);
        } else {
            $data->setBothAntiviralPreceding(null);
        }

        if (array_key_exists("both_antiviral_preceding_date", $entryMeta)) {
            $data->setBothAntiviralPrecedingDate($this->formateDate($entryMeta["both_antiviral_preceding_date"]));
        } else {
            $data->setBothAntiviralPrecedingDate(null);
        }

        if (array_key_exists("both_antiviral_during", $entryMeta)) {
            $data->setBothAntiviralDuring($entryMeta["both_antiviral_during"]);
        } else {
            $data->setBothAntiviralDuring(null);
        }

        if (array_key_exists("both_antiviral_during_date", $entryMeta)) {
            $data->setBothAntiviralDuringDate($this->formateDate($entryMeta["both_antiviral_during_date"]));
        } else {
            $data->setBothAntiviralDuringDate(null);
        }

        if (array_key_exists("both_vac_history_validated", $entryMeta)) {
            $data->setBothVacHistoryValidated($entryMeta["both_vac_history_validated"]);
        } else {
            $data->setBothVacHistoryValidated(null);
        }

        if (array_key_exists("both_lab2_sarscov", $entryMeta)) {
            $data->setBothLab2Sarscov($entryMeta["both_lab2_sarscov"]);
        } else {
            $data->setBothLab2Sarscov("0");
        }

        if (array_key_exists("both_lab2_sarscov_yesno", $entryMeta)) {
            $data->setBothLab2SarscovYesno($entryMeta["both_lab2_sarscov_yesno"]);
        } else {
            $data->setBothLab2SarscovYesno(null);
        }

        if (array_key_exists("both_lab2_sarscov2", $entryMeta)) {
            $data->setBothLab2Sarscov2($entryMeta["both_lab2_sarscov2"]);
        } else {
            $data->setBothLab2Sarscov2("0");
        }

        if (array_key_exists("both_lab2_sarscov2_yesno", $entryMeta)) {
            $data->setBothLab2Sarscov2Yesno($entryMeta["both_lab2_sarscov2_yesno"]);
        } else {
            $data->setBothLab2Sarscov2Yesno(null);
        }

        if (array_key_exists("both_lab2_evd68", $entryMeta)) {
            $data->setBothLab2Evd68($entryMeta["both_lab2_evd68"]);
        } else {
            $data->setBothLab2Evd68("0");
        }

        if (array_key_exists("both_lab2_evd68_yesno", $entryMeta)) {
            $data->setBothLab2Evd68Yesno($entryMeta["both_lab2_evd68_yesno"]);
        } else {
            $data->setBothLab2Evd68Yesno(null);
        }

        if (array_key_exists("both_lab2_others", $entryMeta)) {
            $data->setBothLab2Others($entryMeta["both_lab2_others"]);
        } else {
            $data->setBothLab2Others("0");
        }

        if (array_key_exists("both_lab2_others_yesno", $entryMeta)) {
            $data->setBothLab2OthersYesno($entryMeta["both_lab2_others_yesno"]);
        } else {
            $data->setBothLab2OthersYesno(null);
        }

        if (array_key_exists("both_severity_blood_pressure", $entryMeta)) {
            $data->setBothSeverityBloodPressure($entryMeta["both_severity_blood_pressure"]);
        } else {
            $data->setBothSeverityBloodPressure(null);
        }

        if (array_key_exists("both_severity_blood_pressure_unknow", $entryMeta)) {
            $data->setBothSeverityBloodPressureUnknow($entryMeta["both_severity_blood_pressure_unknow"]);
        } else {
            $data->setBothSeverityBloodPressureUnknow(null);
        }

        //both_display_hasothersymptoms: field de type html => toujours null: field de type html => toujours null

        if (array_key_exists("both_case_identified_based_logs_respiratory", $entryMeta)) {
            $data->setBothCaseIdentifiedBasedLogsRespiratory($entryMeta["both_case_identified_based_logs_respiratory"]);
        } else {
            $data->setBothCaseIdentifiedBasedLogsRespiratory(null);
        }

//        if (array_key_exists("both_case_identified_based_positive_swab", $entryMeta)) {
//            $data->setBothCaseIdentifiedBasedPositiveSwab($entryMeta["both_case_identified_based_positive_swab"]);
//        } else {
//            $data->setBothCaseIdentifiedBasedPositiveSwab(null);
//        }

        if (array_key_exists("both_case_identified_based_testing", $entryMeta)) {
            $data->setBothCaseIdentifiedBasedTesting($entryMeta["both_case_identified_based_testing"]);
        } else {
            $data->setBothCaseIdentifiedBasedTesting(null);
        }

        if (array_key_exists("both_case_definition_used", $entryMeta)) {
            $data->setBothCaseDefinitionUsed($entryMeta["both_case_definition_used"]);
        } else {
            $data->setBothCaseDefinitionUsed(null);
        }

        if (array_key_exists("both_case_definition_other_detail", $entryMeta)) {
            $data->setBothCaseDefinitionotherDetail($entryMeta["both_case_definition_other_detail"]);
        } else {
            $data->setBothCaseDefinitionOtherDetail(null);
        }

        if (array_key_exists("both_lab2_others_detail", $entryMeta)) {
            $data->setBothLab2OthersDetail($entryMeta["both_lab2_others_detail"]);
        } else {
            $data->setBothLab2OthersDetail(null);
        }

        if (array_key_exists("both_antiviral_preceding_date_unknow", $entryMeta)) {
            $data->setBothAntiviralPrecedingDateUnknow($entryMeta["both_antiviral_preceding_date_unknow"]);
        } else {
            $data->setBothAntiviralPrecedingDateUnknow(null);
        }

        if (array_key_exists("both_antiviral_during_date_unknow", $entryMeta)) {
            $data->setBothAntiviralDuringDateUnknow($entryMeta["both_antiviral_during_date_unknow"]);
        } else {
            $data->setBothAntiviralDuringDateUnknow(null);
        }

        if (array_key_exists("both_antibio_preceding_date_unknow", $entryMeta)) {
            $data->setBothAntibioPrecedingDateUnknow($entryMeta["both_antibio_preceding_date_unknow"]);
        } else {
            $data->setBothAntibioPrecedingDateUnknow(null);
        }

        if (array_key_exists("both_antibio_during_date_unknow", $entryMeta)) {
            $data->setBothAntibioDuringDateUnknow($entryMeta["both_antibio_during_date_unknow"]);
        } else {
            $data->setBothAntibioDuringDateUnknow(null);
        }

        //both_display_clinical5bis: field de type html => toujours null: field de type html => toujours null
        if (array_key_exists("both_covid_number_doses", $entryMeta)) {
            $data->setBothCovidNumberDoses($entryMeta["both_covid_number_doses"]);
        } else {
            $data->setBothCovidNumberDoses(null);
        }

        if (array_key_exists("both_covid_last_dose_date", $entryMeta)) {
            $data->setBothCovidLastDoseDate($this->formateDate($entryMeta["both_covid_last_dose_date"]));
        } else {
            $data->setBothCovidLastDoseDate(null);
        }

        if (array_key_exists("both_covid_last_dose_date_unknow", $entryMeta)) {
            $data->setBothCovidLastDoseDateUnknow($entryMeta["both_covid_last_dose_date_unknow"]);
        } else {
            $data->setBothCovidLastDoseDateUnknow(null);
        }

        if (array_key_exists("both_display_covid_vaccine", $entryMeta)) {
            $data->setBothDisplayCovidVaccine($entryMeta["both_display_covid_vaccine"]);
        } else {
            $data->setBothDisplayCovidVaccine(null);
        }

        if (array_key_exists("both_severity_high_dependence_unit", $entryMeta)) {
            $data->setBothSeverityHighDependenceUnit($entryMeta["both_severity_high_dependence_unit"]);
        } else {
            $data->setBothSeverityHighDependenceUnit(null);
        }

        if (array_key_exists("both_d_diag1_unknow", $entryMeta)) {
            $data->setBothDDiag1Unknow($entryMeta["both_d_diag1_unknow"]);
        } else {
            $data->setBothDDiag1Unknow(null);
        }

        if (array_key_exists("both_d_diag2_unknow", $entryMeta)) {
            $data->setBothDDiag2Unknow($entryMeta["both_d_diag2_unknow"]);
        } else {
            $data->setBothDDiag2Unknow(null);
        }

        if (array_key_exists("both_d_diag3_unknow", $entryMeta)) {
            $data->setBothDDiag3Unknow($entryMeta["both_d_diag3_unknow"]);
        } else {
            $data->setBothDDiag3Unknow(null);
        }

        if (array_key_exists("both_lab2_enterovirus", $entryMeta)) {
            $data->setBothLab2Enterovirus($entryMeta["both_lab2_enterovirus"]);
        } else {
            $data->setBothLab2Enterovirus("0");
        }

        if (array_key_exists("both_lab2_enterovirus_yesno", $entryMeta)) {
            $data->setBothLab2EnterovirusYesno(($entryMeta["both_lab2_enterovirus_yesno"]));
        } else {
            $data->setBothLab2EnterovirusYesno(null);
        }

        if (array_key_exists("both_lab2_merscov", $entryMeta)) {
            $data->setBothLab2Merscov($entryMeta["both_lab2_merscov"]);
        } else {
            $data->setBothLab2Merscov("0");
        }

        if (array_key_exists("both_lab2_merscov_yesno", $entryMeta)) {
            $data->setBothLab2MerscovYesno(($entryMeta["both_lab2_merscov_yesno"]));
        } else {
            $data->setBothLab2MerscovYesno(null);
        }

        if (array_key_exists("both_lab2_picornavirus", $entryMeta)) {
            $data->setBothLab2Picornavirus($entryMeta["both_lab2_picornavirus"]);
        } else {
            $data->setBothLab2Picornavirus("0");
        }

        if (array_key_exists("both_lab2_picornavirus_yesno", $entryMeta)) {
            $data->setBothLab2PicornavirusYesno(($entryMeta["both_lab2_picornavirus_yesno"]));
        } else {
            $data->setBothLab2PicornavirusYesno(null);
        }

        if (!$data->getCreatedAt()) {
            $data->setCreatedAt(new \DateTime());
        }

        $data->setUpdatedAt(new \DateTime());

        $data->setTocalculate(1);

        $this->em->persist($data);
    }

    /**
     * @Route("/correctBothDoa", name="correct_both_doa")
     */
    public function correctBothDoa()
    {
        try {
            $list = $this->conn->fetchAll("SELECT id, both_doa FROM `data`  WHERE both_doa is not null and LENGTH(both_doa) > 0");
            foreach ($list as $row) {
                $bothDoaDate = \DateTime::createFromFormat('d/m/Y', $row["both_doa"]);
                if ($bothDoaDate) {
                    $weekYear = $bothDoaDate->format("W--o");
                    $this->conn->exec("update `data` set `week_number` = '" . $weekYear . "'
                 WHERE id =" . $row['id'] . ";");
                }
            }
            return new Response("terminé");
        } catch (\Exception $e) {
            return new Response("error", $e->getMessage());
        }

    }

    /**
     * @Route("/correctBothDoaDashboard", name="correct_both_doa_dashboard")
     */
    public function correctBothDoaDashboard()
    {
        try {
            $list = $this->conn->fetchAll("SELECT id, both_doa FROM `data_dashboard`  WHERE both_doa is not null and LENGTH(both_doa) > 0");
            foreach ($list as $row) {
                $bothDoaDate = \DateTime::createFromFormat('d/m/Y', $row["both_doa"]);
                if ($bothDoaDate) {
                    $weekYear = $bothDoaDate->format("W--o");
                    $this->conn->exec("update `data_dashboard` set `week_number` = '" . $weekYear . "'
                 WHERE id =" . $row['id'] . ";");
                }
            }
            return new Response("terminé");
        } catch (\Exception $e) {
            return new Response("error", $e->getMessage());
        }

    }

    public function formateDate($date)
    {
        // Convert the date string to the desired format (dd/mm/yyyy)
        $formattedDate = date('d/m/Y', strtotime($date));

        return $formattedDate;
    }

    function postSites($wpSites): int
    {
        $nb = 0;
        /* si'il ya des nouveaus sites ajoutés en wordpress: on va l'ajouter dans table site bd:symf
        * S'il y a des sites qui ont été modifiés dans wp, nous les modifierons dans la base de données Symfony
             */
        foreach ($wpSites as $wpSite) {
            $meta = $wpSite['meta'];
            if (array_key_exists("site_id", $meta)) {
                $site_id = $meta["site_id"];
                $site = $this->em->getRepository(Site::class)->find($site_id);
                if (!$site) {
                    $site = new Site();
                    $site->setId($site_id);
                }
                $site->setZone($meta["libelle-site-field"]);

                $this->em->persist($site);
                $nb++;
            }
        }
        $this->em->flush();
        return $nb;
    }

    function calculerSaison($date)
    {

        $date = strtotime($date);
        $annee = date('Y', $date);
        $mois = date('n', $date); // Les mois vont de 1 à 12

        if ($mois >= 11) {

            return substr($annee, 2) . '_' . substr($annee + 1, 2);
        } else {
            return (substr($annee, 2) - 1) . '_' . substr($annee, 2);
        }
    }
}