<?php

namespace App\Controller;


use App\Entity\Main\DataFile;
use App\Entity\Main\Historic;
use App\Entity\Main\Site;
use App\Service\Functions;
use App\Service\GlobalServices;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\QueryBuilder;
use Omines\DataTablesBundle\Adapter\Doctrine\ORMAdapter;
use Omines\DataTablesBundle\Column\DateTimeColumn;
use Omines\DataTablesBundle\Column\TextColumn;
use Omines\DataTablesBundle\DataTableFactory;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/historic")
 */
class HistoricController extends AbstractController
{
    protected $em;
    protected $globalServices;
    private $functions;

    public function __construct(EntityManagerInterface $entityManager,
                                GlobalServices $globalServices,
                                Functions $functions)
    {
        $this->em = $entityManager;
        $this->globalServices = $globalServices;
        $this->functions = $functions;
    }

    /**
     * Description :: historic list
     * @Route("/list", name="historic_list")
     */
    public function historicList(Request $request, DataTableFactory $dataTableFactory)
    {
        if (!$this->getUser()->getManager()) {
            $this->addFlash('danger', "This page is accessible only by platform administrators!");
            return $this->redirectToRoute('error_page');
        }

        $datatable = $dataTableFactory->create([])
            ->createAdapter(ORMAdapter::class, [
                'entity' => Historic::class,
                'query' => function (QueryBuilder $builder) {
                    $builder
                        ->select('historic')
                        ->addSelect('user')
                        ->from(Historic::class, 'historic')
                        ->leftJoin('historic.user', 'user')->orderBy("historic.createdAt", "DESC");
                    if ($this->get('session')->has('filter_historic_list')) {
                        $filters = $this->get('session')->get('filter_historic_list');

                        if ($filters['fullName'] != "") $builder->andWhere("user.id = :id")->setParameter('id', $filters['fullName']);
                        if ($filters['action'] != "") $builder->andWhere("historic.type = :type")->setParameter('type', $filters['action']);
                        if ($filters["dateStart"] != "" )  $builder->andWhere("historic.createdAt >= :start")->setParameter('start', date('Y-m-d', strtotime($filters['dateStart'])). " 00:00:00");
                        if ($filters["dateEnd"] != "" )  $builder->andWhere("historic.createdAt <= :end")->setParameter('end', date('Y-m-d', strtotime($filters['dateEnd'])). " 23:59:59");
                    }
                }
            ])
            ->add('fullName', TextColumn::class, [
                'label' => 'Full name',
                'field' => 'user.fullName',
                'orderable' => false,
            ])
            ->add('action', TextColumn::class, [
                'label' => 'Action',
                'field' => 'historic.action',
                'orderable' => false,
            ])
            ->add('createdAt', DateTimeColumn::class, [
                'label' => 'Date',
                'format' => 'd-m-Y',
                'className' => 'colomn-date',
                'field' => 'historic.createdAt',
                'orderable' => false,
            ])

            ->handleRequest($request);

        if ($datatable->isCallback()) {
            return $datatable->getResponse();
        }

        return $this->render('historic/list.html.twig', [
            'datatable' => $datatable,
        ]);
    }
}