<?php
/**
 * Created by PhpStorm.
 * User: ELLIGY
 * Date: 01/01/2020
 * Time: 18:06
 */

namespace App\Controller;

use App\Entity\Main\Data;
use App\Entity\Main\DoctorSpeciality;
use App\Entity\Main\Site;
use App\Entity\Main\User;
use App\Form\FilterType;
use App\Repository\Main\DataRepository;
use App\Service\EmailsTemplateSender;
use App\Service\Functions;
use App\Service\GlobalServices;
use App\Service\NotificationsTemplateSender;
use Psr\Container\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Contracts\HttpClient\HttpClientInterface;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Shared\XMLWriter;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Reader\Xls;
use PhpOffice\PhpSpreadsheet\Reader\Csv;
use PhpOffice\PhpSpreadsheet\Reader\Xml;


/**
 *
 * @Route("/global")
 */
class GlobalController extends Controller
{
    protected $em;
    private $client;
    protected $globalServices;
    private $functions;

    public function __construct(
        ContainerInterface $container,
        GlobalServices $globalServices,
        Functions $functions,
        HttpClientInterface $client
    )
    {
        $this->em = $container->get('doctrine.orm.default_entity_manager');
        $this->client = $client;
        $this->globalServices = $globalServices;
        $this->functions = $functions;

    }

    /**
     * Description :: filtre datatable
     * @Route("/filtre_datatable", name="filtre_datatable")
     */
    public function filtreDatatable(Request $request, $fields = null, $from_route = null)
    {
        $session = $this->get('session');

        if ($request->isXmlHttpRequest() && $request->request->has('setFilterDatas')) {
            $session->set($request->request->get('filter_session_key'), $request->request->all());
            return new JsonResponse(['status' => 200]);
        }else{
            $this->get('session')->remove('filter_' . $from_route);
        }

        if($from_route == "historic_list"){
            $users = $this->em->getRepository(User::class)->findBy(array(),array('fullName' => 'ASC'));
            $keyFullName = [];
            $valueFullName = [];
            foreach ( $users as $user ) {
                array_push($keyFullName, $user->getFullName());
                array_push($valueFullName, $user->getId());
            }
            $formFilter = $this->createForm(FilterType::class, null,[
                'add' => $fields,
                'fullNames' => array_combine($keyFullName, $valueFullName)
            ]);
        }else{
            $formFilter = $this->createForm(FilterType::class, null,[
                'add' => $fields,
            ]);
        }
        $formFilter->handleRequest($request);

        return $this->render('global/other/filter_datatable.html.twig', [
            'fields' => $fields,
            'filter_key_request' => 'filter_' . $from_route,
            'formFilter' => $formFilter->createView(),
        ]);
    }

    /**
     * Description :: global function to export data to an excel file.
     * @Route("/export_excel_datatable", name="export_excel_datatable")
     */
    public function exportExcelDatatable(Request $request)
    {
        set_time_limit(7200);
        ini_set('memory_limit', '-1');
        if ($request->isXmlHttpRequest()) {
            $header = $request->request->get("thead");
            $body = $request->request->get("tbody");
            $pageTitle = $request->request->get("pageTitle");

            $excel_dt = [
                "pageTitle" => $pageTitle,
                "header" => $header,
                "body" => $body
            ];

            $this->get('session')->set('excel_dt', $excel_dt);
            return new JsonResponse(
                array(
                    "message" => 'Session enregistré avec succès'
                )
            );
        }
        $excel_dt = $this->get('session')->get('excel_dt');
        $pageTitle = $excel_dt['pageTitle'];
        $header = json_decode($excel_dt['header'], true);
        $body = json_decode($excel_dt['body'], true);

        $spreadsheet = new Spreadsheet();
        $Excel_writer = new Xlsx($spreadsheet);
        $spreadsheet->setActiveSheetIndex(0);
        $activeSheet = $spreadsheet->getActiveSheet();

        $col = 0;
        foreach ($header as $key => $label) {
            $activeSheet->setCellValue($this->globalServices->functions->excelCellName($col) . '1', $label);
            $col++;
        }

        $row = 2;
        foreach ($body as $line) {
            $col = 0;
            foreach ($header as $key => $label) {
                $value = $line[$key];
                if (strpos($value, "</span>") > 0) {
                    $value = substr($value, strpos($value, '">') + 2, -7);
                }
                $activeSheet->setCellValue($this->functions->excelCellName($col) . $row, $value);
                $col++;
            }
            $row++;
        }
        $filename = $pageTitle . '_' . (new \DateTime())->format('d_m_Y_H_i') . '.xlsx';

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $filename);
        header('Cache-Control: max-age=0');
        $Excel_writer->save('php://output');
        exit;
    }


    /**
     * Description :: error page
     * @Route("/error_page", name="error_page")
     */
    public function errorPage()
    {
        return $this->render('global/other/error_page.html.twig');
    }
}
