<?php
// src/Command/CreateUserCommand.php
namespace App\Command;

use App\Entity\Main\Demand;
use App\Service\EmailsTemplateSender;
use Symfony\Component\Console\Input\InputOption;
use App\Controller\VariableController;
use App\Entity\Main\Data;
use App\Service\Functions;
use App\Service\GlobalServices;
use Doctrine\ORM\EntityManagerInterface;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Doctrine\DBAL\Driver\Connection;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

class ExportCommand extends Command
{
    protected static $defaultName = 'app:export';


    protected $em;
    protected $globalServices;
    private $functions;
    private $conn;
    private $emailsTemplateSender;
    private $params;

    public function __construct(EntityManagerInterface $entityManager,
                                GlobalServices         $globalServices,
                                Functions              $functions,
                                Connection             $conn,
                                EmailsTemplateSender   $emailsTemplateSender,
                                ParameterBagInterface  $params
    )
    {
        $this->em = $entityManager;
        $this->globalServices = $globalServices;
        $this->functions = $functions;
        $this->conn = $conn;
        $this->emailsTemplateSender = $emailsTemplateSender;
        $this->params = $params;
        parent::__construct();
    }


    protected function configure(): void
    {
        $this
            ->setDescription('Add a short description for your command')
            ->addArgument('arg1', InputArgument::OPTIONAL, 'Id demand')
            ->addArgument('arg2', InputArgument::OPTIONAL, 'email')
            ->addArgument('arg3', InputArgument::OPTIONAL, 'fullName')
            ->addOption('option1', null, InputOption::VALUE_NONE, 'Option description');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        // instantiate SymfonyStyle to manage the style of command input and output
        $io = new SymfonyStyle($input, $output);
        $path = $this->params->get('PATH_EXPORT');
        $url = $this->params->get('URL_FILE');

        // ID de l'enregistrement qui contient la liste des filters
        $arg1 = $input->getArgument('arg1'); // id of the demand
        $arg2 = $input->getArgument('arg2'); // email of the user who create the demand
        $arg3 = $input->getArgument('arg3'); // fullname of the user who create the demand

        // check if we have all the necessary information to start the export
        if ($arg1 && $arg2 && $arg3) {
            set_time_limit(7200);
            ini_set('memory_limit', '-1');

            $io->success(date('H:i:s'));

            $pageTitle = "data_list";
            $filename = $pageTitle . '_' . (new \DateTime())->format('d_m_Y_H_i');
            $filecsv = $path . "/public/uploads/export/" . $filename . ".csv";

            // get the demand request to export
            $demand = $this->conn->fetchAll('select age,checked from demand where id=' . $arg1);
            $seasan = json_decode($demand[0]['checked']);
            $filterage = "";
            $demandAge = $demand[0]['age'];
            if ($demandAge != '' && $demandAge != NULL) {
                $age = explode(',', $demandAge);
                $filterage = ' AND ( IF(d.both_age_unit = 3, (d.both_age/365) BETWEEN ' . (int)$age[0] . ' AND ' . (int)$age[1] . ', 
                                     IF(d.both_age_unit = 2 , (d.both_age/12)  BETWEEN ' . (int)$age[0] . ' AND ' . (int)$age[1] . ',
                                     d.both_age  between ' . (int)$age[0] . ' AND ' . (int)$age[1] . ')))';
            }
            $tabsql = [];

            //select the list of fields to be exported
            $sql = "select s.zone as zone, `season`, `is_validated`, `both_comp_a_diag`, `both_a_diag`, `both_a_diag_icd`, 
                if(both_doa is not null and both_doa != '', date_format(STR_TO_DATE(both_doa,'%d/%m/%Y'), '%v--%x'), '') as both_doa, 
                
                if(both_doa is not null and both_doa != '' and both_discharged_date is not null and both_discharged_date != '', 
                    DATEDIFF( STR_TO_DATE(both_discharged_date,'%d/%m/%Y'), STR_TO_DATE(both_doa,'%d/%m/%Y') ), '') as `both_discharged_date`, 
                    
                if(both_doa is not null and both_doa != '' and both_swab_date is not null and both_swab_date != '', 
                    DATEDIFF( STR_TO_DATE(both_swab_date,'%d/%m/%Y'), STR_TO_DATE(both_doa,'%d/%m/%Y') ), '') as `both_swab_date`, 
                    
                if(both_doa is not null and both_doa != '' and both_antiviral_preceding_date is not null and both_antiviral_preceding_date != '', 
                    DATEDIFF( STR_TO_DATE(both_antiviral_preceding_date,'%d/%m/%Y'), STR_TO_DATE(both_doa,'%d/%m/%Y') ), '') as `both_antiviral_preceding_date`,
                     
                if(both_doa is not null and both_doa != '' and both_antiviral_during_date is not null and both_antiviral_during_date != '', 
                    DATEDIFF( STR_TO_DATE(both_antiviral_during_date,'%d/%m/%Y'), STR_TO_DATE(both_doa,'%d/%m/%Y') ), '') as `both_antiviral_during_date`,
                     
                if(both_doa is not null and both_doa != '' and `both_antibio_preceding_date` is not null and `both_antibio_preceding_date` != '', 
                    DATEDIFF( STR_TO_DATE(`both_antibio_preceding_date`,'%d/%m/%Y'), STR_TO_DATE(both_doa,'%d/%m/%Y') ), '') as `both_antibio_preceding_date`,
                     
                if(both_doa is not null and both_doa != '' and `both_antibio_during_date` is not null and `both_antibio_during_date` != '', 
                    DATEDIFF( STR_TO_DATE(`both_antibio_during_date`,'%d/%m/%Y'), STR_TO_DATE(both_doa,'%d/%m/%Y') ), '') as `both_antibio_during_date`,
                     
                if(both_doa is not null and both_doa != '' and `both_av_starting_date` is not null and `both_av_starting_date` != '', 
                    DATEDIFF( STR_TO_DATE(`both_av_starting_date`,'%d/%m/%Y'), STR_TO_DATE(both_doa,'%d/%m/%Y') ), '') as `both_av_starting_date`,
                
                if(both_doa is not null and both_doa != '' and `doq` is not null and `doq` != '', 
                    DATEDIFF( STR_TO_DATE(`doq`,'%d/%m/%Y'), STR_TO_DATE(both_doa,'%d/%m/%Y') ), '') as `doq`,
                 
                if(both_doa is not null and both_doa != '' and `dob` is not null and `dob` != '', 
                    DATEDIFF( STR_TO_DATE(`dob`,'%d/%m/%Y'), STR_TO_DATE(both_doa,'%d/%m/%Y') ), '') as `dob`,
                
                if(both_doa is not null and both_doa != '' and `dol` is not null and `dol` != '', 
                    DATEDIFF( STR_TO_DATE(`dol`,'%d/%m/%Y'), STR_TO_DATE(both_doa,'%d/%m/%Y') ), '') as `dol`,
                
                if(both_doa is not null and both_doa != '' and `dov` is not null and `dov` != '', 
                    DATEDIFF( STR_TO_DATE(`dov`,'%d/%m/%Y'), STR_TO_DATE(both_doa,'%d/%m/%Y') ), '') as `dov`,
                
                if(both_doa is not null and both_doa != '' and `doo` is not null and `doo` != '', 
                    DATEDIFF( STR_TO_DATE(`doo`,'%d/%m/%Y'), STR_TO_DATE(both_doa,'%d/%m/%Y') ), '') as `doo`,
                                
                if(both_doa is not null and both_doa != '' and `both_covid_last_dose_date` is not null and `both_covid_last_dose_date` != '', 
                    DATEDIFF( STR_TO_DATE(`both_covid_last_dose_date`,'%d/%m/%Y'), STR_TO_DATE(both_doa,'%d/%m/%Y') ), '') as `both_covid_last_dose_date`,
               
               if(both_doa is not null and both_doa != '' and `both_swabcovid_date` is not null and `both_swabcovid_date` != '', 
                    DATEDIFF( STR_TO_DATE(`both_swabcovid_date`,'%d/%m/%Y'), STR_TO_DATE(both_doa,'%d/%m/%Y') ), '') as `both_swabcovid_date`,
                    
                `both_sex`, `soc_class`, `smoking_hab`, `both_chronic_cond_yn`, `both_chronic_cvd_blood`, `both_chronic_copd`, `both_chronic_asthma`,
                `both_chronic_diabetes`, `both_chronic_immuno`, `both_chronic_renal`, `both_chronic_rheumatologic_autoimmune_dis`,
                `both_chronic_neurological_neuromuscular_dis`, `both_chronic_cirrhosis_liver_dis`, `both_chronic_neoplasm`, `both_chronic_obesity`,
                `both_chronic_malnutri`, `both_chronic_active_tuberculosis`, `both_chronic_hiv_infection`,`both_chronic_hiv_exposure`,
                `both_chronic_other`, `hosp_12m`, `av_current_days`, `both_av_current`, `both_influ_vac_current_season`, `both_vac_14d_before_ili_sym`,
                `vac_name`, `vac_type`, `both_vac_preceding_season`, `both_swab_date_unknow`, `hypoxia_adm`, `lethargy_adm`,
                `both_severity_oxygen_saturation`, `both_severity_oxygen_saturation_unknow`, `both_severity_blood_pressure`, 
                `both_severity_blood_pressure_unknow`, `both_severity_respiration_rate`, `both_severity_respiration_rate_unknow`,
                `blood_urea_nitrogen`, `both_severity_supp_oxygen`, `both_severity_vaso_support`, `both_icu_adm`, `both_death_hosp`, 
                `both_severity_mech_vent`, `both_d_diag1`, `both_d_diag2`, `both_d_diag3`, `both_d_icd`, `both_positive_result`,`both_lab_flu_h1n1`,
                `both_lab_flu_h3n2`, `both_lab_flu_yamagata`, `both_lab_flu_victoria`, `both_lab_flu_h1nother`, `both_lab_flu_h3nother`, `both_lab_flu_a_nosub`, `both_lab_flu_b_nosub`, 
                `both_lab2_corona_yesno`, `both_lab2_metaneumo_yesno`, `both_lab2_rs_yesno`, `both_lab2_adeno_yesno`, `both_lab2_boca_yesno`,
                `both_lab2_pi_yesno`, `both_lab2_rhino_yesno`, `both_ilisystemic_fever`, `both_ilisystemic_malaise`, 
                `both_ilisystemic_headache`, `both_ilisystemic_myalgia`, `both_ilirespiratory_cough`, `both_ilirespiratory_sorethroat`,
                `both_ilirespiratory_shortnessbreath`, `both_ilirespiratory_nasalcongestion`, `both_epi_isl`, `both_pregnancy_status`,
                `both_pregnancy_weeks`, `both_pregnancy_weeks_unknow`, `both_test_other_virus`, `both_height`, `both_weight`, `both_height_unknow`,
                `both_weight_unknow`, `birthweight`, `gestbirth_wk_yn`, `gestbirth_wk`, `breastfed_yn`, 
                `breastfed_month_time`, `temperature_adm`, `both_chronic_prematurity`, `less_chronic_down_syndrom`, `less_chronic_congenital_heart_dis`,
                `more_chronic_leukemia`, `both_chronic_hemoglobinopathies`, `both_antibio_preceding`,  `both_frailty_score`, `both_frailty_score_unknow`,
                `less_influ_vac_current_season_2_doses`, `barthel_index`, `both_severity_confusion`, `both_severity_apnea`,
                `both_discharge_another_hopital`, `both_frailty_score_discharge`, `both_frailty_score_discharge_unknow`, `both_sample_submited`,
                `both_lab2_corona`, `both_lab2_metaneumo`, `both_lab2_rs`, `both_lab2_adeno`, `both_lab2_boca`, `both_lab2_pi`, `both_lab2_rhino`, 
                `both_othersymptoms_nausea`, `both_othersymptoms_diarrhea`, `both_othersymptoms_smell`, `both_othersymptoms_chestpain`, 
                `both_ilirespiratory_wheezing`, `both_antibio_during`, `both_antiviral_preceding`, `both_antiviral_during`, `both_vac_history_validated`,                
                `both_lab2_sarscov2`, `both_lab2_sarscov2_yesno`, `both_lab2_evd68`, `both_lab2_evd68_yesno`, `both_lab2_others`, `both_lab2_others_yesno`, `more_covid_firstdose`, `more_covid_full`,
                `more_covid_vaccine`, `ecmo`, `contra_flu`, `polypnea`, `orv_plus`, `orv_plus_sans_rsv`, `orv_plus_sans_sars_cov_2`, 
                `orv_plus_sans_rsv_sans_sars_cov_2`, `test_orv`, `test_orv_sans_rsv`, `test_orv_sans_sars_cov_2`, `test_orv_sans_rsv_sans_sars_cov_2`,
                `both_age`, `both_age_unit`, `both_a_diag_unknow`,
                `both_case_identified_based_logs_respiratory`, `both_case_identified_based_testing`, `both_case_definition_used`, 
                `both_case_definition_other_detail`,`both_lab2_others_detail`, `both_antiviral_preceding_date_unknow`,
                `both_antiviral_during_date_unknow`,`both_antibio_preceding_date_unknow`, `both_antibio_during_date_unknow`, `both_vac_type_vaccine`,
                `both_covid_number_doses`, `both_covid_last_dose_date_unknow`, `both_covid_vaccine_mrna`, `both_covid_vaccine_inactivated_virion`,
                `both_covid_vaccine_viral_vector`, `both_covid_vaccine_protein_subunit`, `both_covid_vaccine_unknow`, `both_severity_high_dependence_unit`,
                `both_d_diag1_unknow`, `both_d_diag2_unknow`, `both_d_diag3_unknow`, `both_sample_type`, `both_swabcovid_date_unknow`,
                `both_sample_submited_influenza`, `both_epi_isl_influenza`,`both_sample_submited_sars_cov2`, `both_epi_isl_sars_cov2`,
                `both_sample_submited_rsv`, `both_epi_isl_rsv`, `both_lab2_enterovirus`, `both_lab2_enterovirus_yesno`, `both_lab2_merscov`, `both_lab2_merscov_yesno`,
                 `both_lab2_picornavirus`, `both_lab2_picornavirus_yesno`, `both_lab2_sarscov`, `both_lab2_sarscov_yesno`
                FROM `data` d , site s WHERE `d`.`site_id` = `s`.`id` AND `d`.`included` = 1 ";

            foreach ($seasan as $item) {
                $tabsql[] = $sql . " AND d.season = '" . $item[0] . "' AND d.site_id = '" . $item[1] . "' " . $filterage;
            }

            dump('created');
            // generation fichier csv
            $fp = fopen($filecsv, 'w');

            dump('file opened');

            $rs = $this->conn->fetchAll(implode(' union all ', $tabsql));

            if ($rs) {
                fputcsv($fp, array_keys($rs[0]), ";", '"');
                foreach ($rs as $data) {

                    $keys = array_keys($data);
                    for ($i = 0; $i < count($keys); $i++) {
                        if ($data[$keys[$i]] != null && $data[$keys[$i]] != '') {
                            $data[$keys[$i]] = trim(str_replace(['"', "'", "\\", '\\', ';'], ' ', $data[$keys[$i]]));
                        }
                    }

                    fputcsv($fp, $data, ";", '"');
                }
                fclose($fp);
                $io->success(date('H:i:s'));
                $io->success('Export terminer');

                // convertion du csv en xls
//                try{ exec("ssconvert $filecsv $filexlsx "); }catch(\Exception $e){}

                $demand = $this->conn->exec('UPDATE `demand` SET `file_export`="' . $filename . '.csv",`email_sended`= "You can download this export from this url ' . $url . $filename . '.csv.  Email : ' . $arg2 . '" WHERE id= ' . $arg1);
                if ($arg2 != 'no') {
                    $this->emailsTemplateSender->email_send_export($filename . '.csv', $arg2, str_replace("_", " ", $arg3));
                }
                $io->success("echange de data entre commande et controller => ");

            }
            return 0;
        }
        $io->success('erreur id manquant');
        return 0;

    }
}
