<?php
// src/Command/CreateUserCommand.php
namespace App\Command;

use App\Entity\Main\Demand;
use App\Service\EmailsTemplateSender;
use Symfony\Component\Console\Input\InputOption;
use App\Controller\VariableController;
use App\Entity\Main\Data;
use App\Service\Functions;
use App\Service\GlobalServices;
use Doctrine\ORM\EntityManagerInterface;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Doctrine\DBAL\Driver\Connection;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

class CompletenessDatabaseExportCommande extends Command
{
    protected static $defaultName = 'app:completeness:database:export';


    protected $em;
    protected $globalServices;
    private $functions;
    private $conn;
    private $emailsTemplateSender;
    private $params;

    public function __construct(EntityManagerInterface $entityManager,
                                GlobalServices         $globalServices,
                                Functions              $functions,
                                Connection             $conn,
                                EmailsTemplateSender   $emailsTemplateSender,
                                ParameterBagInterface  $params
    )
    {
        $this->em = $entityManager;
        $this->globalServices = $globalServices;
        $this->functions = $functions;
        $this->conn = $conn;
        $this->emailsTemplateSender = $emailsTemplateSender;
        $this->params = $params;
        parent::__construct();
    }


    protected function configure(): void
    {
        $this
            ->setDescription('Add a short description for your command')
            ->addArgument('arg1', InputArgument::OPTIONAL, 'email')
            ->addArgument('arg2', InputArgument::OPTIONAL, 'fullName')
            ->addOption('option1', null, InputOption::VALUE_NONE, 'Option description');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        // instantiate SymfonyStyle to manage the style of command input and output
        $io = new SymfonyStyle($input, $output);
        $path = $this->params->get('PATH_EXPORT');

        $arg1 = $input->getArgument('arg1'); // email of the user who create the demand
        $arg2 = $input->getArgument('arg2'); // fullname of the user who create the demand

        // check if we have all the necessary information to start the export
        if ($arg1 && $arg2) {
            set_time_limit(7200);
            ini_set('memory_limit', '-1');

            $io->success(date('H:i:s'));

            $pageTitle = "completness_database_export";
            $filename = $pageTitle . '_' . (new \DateTime())->format('d_m_Y_H_i');
            $filexlsx = $path . "/public/uploads/export/" . $filename . ".xlsx";

            // select all seasons ordered
            $seasons = $this->conn->fetchAll("SELECT DISTINCT season FROM data order by season");

            $spreadsheet = new Spreadsheet();

            foreach ($seasons as $seasonRow) {
                $season = $seasonRow['season'];
                $sheet = $spreadsheet->createSheet()->setTitle($season);

                // Column headings
                // $columns = $this->conn->fetchAll("SHOW COLUMNS FROM data");
                // $columnNames = array_column($columns, 'Field');
                $columnNames = array("site_id", "both_id_patient", "both_age", "both_age_unit", "both_doa", "id_bdd_philippe", "id_site_bdd_philippe", "date_last_modified", "id_last_modificator", "name_last_modificator", "is_validated", "OHC_TECH_ID", "OHC_TECH_IdIntegration", "OHC_TECH_SEA_ID", "form_type", "both_comp_a_diag", "both_a_diag", "both_a_diag_icd", "both_id_hospital", "doq", "both_sex", "dob", "communication", "consents", "residence", "institutionalized", "exclussion_hosp", "soc_class", "smoking_hab", "both_chronic_cond_yn", "both_display_clinical3", "both_chronic_cvd_blood", "both_chronic_copd", "both_chronic_asthma", "both_chronic_diabetes", "both_chronic_immuno", "both_chronic_renal", "both_chronic_rheumatologic_autoimmune_dis", "both_chronic_neurological_neuromuscular_dis", "both_chronic_cirrhosis_liver_dis", "both_chronic_neoplasm", "both_chronic_obesity", "both_chronic_malnutri", "both_chronic_active_tuberculosis", "both_chronic_hiv_infection", "both_chronic_hiv_exposure", "both_chronic_other", "hosp_12m", "av_current_days", "both_av_current", "both_av_starting_date", "previous_lab", "both_influ_vac_current_season", "both_vac_14d_before_ili_sym", "dov", "vac_name", "vac_type", "both_vac_preceding_season", "both_swab_date", "both_swab_date_unknow", "swab_sent", "swab_np", "swab_n", "swab_p", "dol", "hypoxia_adm", "lethargy_adm", "both_severity_oxygen_saturation", "both_severity_oxygen_saturation_unknow", "both_severity_respiration_rate", "both_severity_respiration_rate_unknow", "blood_urea_nitrogen", "both_severity_supp_oxygen", "both_severity_vaso_support", "both_icu_adm", "both_death_hosp", "both_severity_mech_vent", "both_discharged_date", "both_d_diag1", "both_d_diag2", "both_d_diag3", "both_d_icd", "both_positive_result", "both_display_labo2", "both_lab_flu_h1n1", "both_lab_flu_h3n2", "both_lab_flu_yamagata", "both_lab_flu_victoria", "both_lab_flu_h1nother", "both_lab_flu_h3nother", "both_lab_flu_a_nosub", "both_lab_flu_b_nosub", "both_lab2_corona_yesno", "both_lab2_metaneumo_yesno", "both_lab2_rs_yesno", "both_lab2_adeno_yesno", "both_lab2_boca_yesno", "both_lab2_pi_yesno", "both_lab2_rhino_yesno", "lab_mix", "both_detected_coinfection", "lab_negative", "sym_7d_yn", "both_display_ilisystemic", "both_ilisystemic_fever", "both_ilisystemic_malaise", "both_ilisystemic_headache", "both_ilisystemic_myalgia", "both_ilirespiratory_cough", "both_ilirespiratory_sorethroat", "both_ilirespiratory_shortnessbreath", "both_display_ilirespiratory", "both_ilirespiratory_nasalcongestion", "doo", "both_epi_isl", "both_display_clinical2", "both_display_clinical4", "both_display_clinical5", "both_display_clinical6", "both_display_clinical7", "both_pregnancy_status", "both_pregnancy_weeks", "both_pregnancy_weeks_unknow", "both_display_hasonesymptoms", "comp_ili", "comp_ili_7d", "more_comply", "both_test_other_virus", "both_display_test_other2", "display_titre_labo", "both_height", "both_weight", "both_height_unknow", "both_weight_unknow", "birthweight", "gestbirth_wk_yn", "gestbirth_wk", "exclu_breast_fed", "breastfed_yn", "breastfed_month_time", "temperature_adm", "both_chronic_prematurity", "less_chronic_down_syndrom", "less_chronic_congenital_heart_dis", "more_chronic_leukemia", "both_chronic_hemoglobinopathies", "both_antibio_preceding", "both_antibio_preceding_date", "both_frailty_score", "both_frailty_score_unknow", "less_influ_vac_current_season_2_doses", "barthel_index", "both_severity_confusion", "both_severity_apnea", "both_discharge_another_hopital", "both_frailty_score_discharge", "both_frailty_score_discharge_unknow", "both_sample_submited", "both_display_gisaid", "less_display_intro", "more_display_intro", "SysStartTime", "SysEndTime", "OHC_CleSignature", "OHC_Signature", "both_display_clinical6b", "both_lab2_corona", "both_lab2_metaneumo", "both_lab2_rs", "both_lab2_adeno", "both_lab2_boca", "both_lab2_pi", "both_lab2_rhino", "both_display_hasothersymptoms", "both_othersymptoms_nausea", "both_othersymptoms_diarrhea", "both_othersymptoms_smell", "both_othersymptoms_chestpain", "both_ilirespiratory_wheezing", "both_antibio_during", "both_antibio_during_date", "both_antiviral_preceding", "both_antiviral_preceding_date", "both_antiviral_during", "both_antiviral_during_date", "both_vac_history_validated", "more_display_comment", "less_display_comment", "both_lab2_sarscov2", "both_lab2_sarscov2_yesno", "both_lab2_evd68", "both_lab2_evd68_yesno", "both_lab2_others", "both_lab2_others_yesno", "more_covid_firstdose", "more_covid_full", "more_covid_vaccine", "flu_vac_2010_11", "flu_vac_2011_12", "flu_vac_2012_13", "flu_vac_2013_14", "flu_vac_2014_15", "flu_vac_2015_16", "flu_vac_2016_17", "flu_vac_2017_18", "flu_vac_2018_19", "flu_vac_2019_20", "flu_vac_2020_21", "flu_vac_2021_22", "flu_vac_2022_23", "flu_vac_2023_24", "flu_vac_2024_25", "flu_vac_2026_27", "ecmo", "reason_no_com", "consul_3m", "contra_flu", "sudden", "polypnea", "both_severity_blood_pressure", "both_severity_blood_pressure_unknow", "both_display_intro", "both_display_how_patient_was_identified", "both_a_diag_unknow", "both_case_identified_based_logs_respiratory", "both_case_identified_based_testing", "both_case_definition_used", "both_case_definition_other_detail", "both_lab2_others_detail", "both_antiviral_preceding_date_unknow", "both_antiviral_during_date_unknow", "both_antibio_preceding_date_unknow", "both_antibio_during_date_unknow", "both_vac_type_vaccine", "both_display_clinical5bis", "both_covid_number_doses", "both_covid_last_dose_date", "both_swabcovid_date", "both_covid_last_dose_date_unknow", "both_display_covid_vaccine", "both_covid_vaccine_mrna", "both_covid_vaccine_inactivated_virion", "both_covid_vaccine_viral_vector", "both_covid_vaccine_protein_subunit", "both_covid_vaccine_unknow", "both_severity_high_dependence_unit", "both_d_diag1_unknow", "both_d_diag2_unknow", "both_d_diag3_unknow", "both_sample_type", "both_swabcovid_date_unknow", "included", "screened", "sequenced", "exclusion", "lci_plus", "orv_plus", "test_orv", "week_number", "length_of_hospital_stay", "orv_plus_sans_rsv", "orv_plus_sans_sars_cov_2", "orv_plus_sans_rsv_sans_sars_cov_2", "test_orv_sans_rsv", "test_orv_sans_rsv_sans_sars_cov_2", "test_orv_sans_sars_cov_2", "tranche_age_def1", "tranche_age_def2", "tranche_age_def3","both_sample_submited_influenza", "both_epi_isl_influenza","both_sample_submited_sars_cov2", "both_epi_isl_sars_cov2","both_epi_isl_rsv");
//                $columnNames = array("site_id","age", "less_age_months", "more_age_years", "less_othersymptoms_fever", "fever_adm", "less_othersymptoms_malaise", "less_othersymptoms_headache", "less_othersymptoms_myalgia","less_othersymptoms_cough", "less_othersymptoms_sorethroat","less_othersymptoms_shortnessofbreath", "less_othersymptoms_nasalcongestion", "both_id_patient", "both_age", "both_age_unit", "both_doa", "id_bdd_philippe", "id_site_bdd_philippe", "date_last_modified", "id_last_modificator", "name_last_modificator", "is_validated", "OHC_TECH_ID", "OHC_TECH_IdIntegration", "OHC_TECH_SEA_ID", "form_type", "both_comp_a_diag", "both_a_diag", "both_a_diag_icd", "both_id_hospital", "doq", "both_sex", "dob", "communication", "consents", "residence", "institutionalized", "exclussion_hosp", "soc_class", "smoking_hab", "both_chronic_cond_yn", "both_display_clinical3", "both_chronic_cvd_blood", "both_chronic_copd", "both_chronic_asthma", "both_chronic_diabetes", "both_chronic_immuno", "both_chronic_renal", "both_chronic_rheumatologic_autoimmune_dis", "both_chronic_neurological_neuromuscular_dis", "both_chronic_cirrhosis_liver_dis", "both_chronic_neoplasm", "both_chronic_obesity", "both_chronic_malnutri", "both_chronic_active_tuberculosis", "both_chronic_hiv_infection", "both_chronic_hiv_exposure", "both_chronic_other", "hosp_12m", "av_current_days", "both_av_current", "both_av_starting_date", "previous_lab", "both_influ_vac_current_season", "both_vac_14d_before_ili_sym", "dov", "vac_name", "vac_type", "both_vac_preceding_season", "both_swab_date", "both_swab_date_unknow", "swab_sent", "swab_np", "swab_n", "swab_p", "dol", "hypoxia_adm", "lethargy_adm", "both_severity_oxygen_saturation", "both_severity_oxygen_saturation_unknow", "both_severity_respiration_rate", "both_severity_respiration_rate_unknow", "blood_urea_nitrogen", "both_severity_supp_oxygen", "both_severity_vaso_support", "both_icu_adm", "both_death_hosp", "both_severity_mech_vent", "both_discharged_date", "both_d_diag1", "both_d_diag2", "both_d_diag3", "both_d_icd", "both_positive_result", "both_display_labo2", "both_lab_flu_h1n1", "both_lab_flu_h3n2", "both_lab_flu_yamagata", "both_lab_flu_victoria", "both_lab_flu_a_nosub", "both_lab_flu_b_nosub", "both_lab2_corona_yesno", "both_lab2_metaneumo_yesno", "both_lab2_rs_yesno", "both_lab2_adeno_yesno", "both_lab2_boca_yesno", "both_lab2_pi_yesno", "both_lab2_rhino_yesno", "lab_mix", "both_detected_coinfection", "lab_negative", "sym_7d_yn", "both_display_ilisystemic", "both_ilisystemic_fever", "both_ilisystemic_malaise", "both_ilisystemic_headache", "both_ilisystemic_myalgia", "both_ilirespiratory_cough", "both_ilirespiratory_sorethroat", "both_ilirespiratory_shortnessbreath", "both_display_ilirespiratory", "both_ilirespiratory_nasalcongestion", "doo", "both_epi_isl", "both_display_clinical2", "both_display_clinical4", "both_display_clinical5", "both_display_clinical6", "both_display_clinical7", "both_pregnancy_status", "both_pregnancy_weeks", "both_pregnancy_weeks_unknow", "both_display_hasonesymptoms", "comp_ili", "comp_ili_7d", "more_comply", "both_test_other_virus", "both_display_test_other2", "display_titre_labo", "both_height", "both_weight", "both_height_unknow", "both_weight_unknow", "birthweight", "gestbirth_wk_yn", "gestbirth_wk", "exclu_breast_fed", "breastfed_yn", "breastfed_month_time", "temperature_adm", "both_chronic_prematurity", "less_chronic_down_syndrom", "less_chronic_congenital_heart_dis", "more_chronic_leukemia", "both_chronic_hemoglobinopathies", "both_antibio_preceding", "both_antibio_preceding_date", "both_frailty_score", "both_frailty_score_unknow", "less_influ_vac_current_season_2_doses", "barthel_index", "both_severity_confusion", "both_severity_apnea", "both_discharge_another_hopital", "both_frailty_score_discharge", "both_frailty_score_discharge_unknow", "both_sample_submited", "both_display_gisaid", "less_display_intro", "more_display_intro", "SysStartTime", "SysEndTime", "OHC_CleSignature", "OHC_Signature", "both_display_clinical6b", "both_lab2_corona", "both_lab2_metaneumo", "both_lab2_rs", "both_lab2_adeno", "both_lab2_boca", "both_lab2_pi", "both_lab2_rhino", "both_display_hasothersymptoms", "both_othersymptoms_nausea", "both_othersymptoms_diarrhea", "both_othersymptoms_smell", "both_othersymptoms_chestpain", "both_ilirespiratory_wheezing", "both_antibio_during", "both_antibio_during_date", "both_antiviral_preceding", "both_antiviral_preceding_date", "both_antiviral_during", "both_antiviral_during_date", "both_vac_history_validated", "more_display_comment", "less_display_comment", "both_lab2_sarscov2", "both_lab2_sarscov2_yesno", "both_lab2_evd68", "both_lab2_evd68_yesno", "both_lab2_others", "both_lab2_others_yesno", "more_covid_firstdose", "more_covid_full", "more_covid_vaccine", "flu_vac_2010_11", "flu_vac_2011_12", "flu_vac_2012_13", "flu_vac_2013_14", "flu_vac_2014_15", "flu_vac_2015_16", "flu_vac_2016_17", "flu_vac_2017_18", "flu_vac_2018_19", "flu_vac_2019_20", "flu_vac_2020_21", "flu_vac_2021_22", "flu_vac_2022_23", "flu_vac_2023_24", "flu_vac_2024_25", "flu_vac_2026_27", "ecmo", "reason_no_com", "consul_3m", "contra_flu", "sudden", "polypnea", "both_severity_blood_pressure", "both_severity_blood_pressure_unknow", "both_display_intro", "both_display_how_patient_was_identified", "both_a_diag_unknow", "both_case_identified_based_logs_respiratory", "both_case_identified_based_testing", "both_case_definition_used", "both_case_definition_other_detail", "both_lab2_others_detail", "both_antiviral_preceding_date_unknow", "both_antiviral_during_date_unknow", "both_antibio_preceding_date_unknow", "both_antibio_during_date_unknow", "both_vac_type_vaccine", "both_display_clinical5bis", "both_covid_number_doses", "both_covid_last_dose_date", "both_swabcovid_date", "both_covid_last_dose_date_unknow", "both_display_covid_vaccine", "both_covid_vaccine_mrna", "both_covid_vaccine_inactivated_virion", "both_covid_vaccine_viral_vector", "both_covid_vaccine_protein_subunit", "both_covid_vaccine_unknow", "both_severity_high_dependence_unit", "both_d_diag1_unknow", "both_d_diag2_unknow", "both_d_diag3_unknow", "both_sample_type", "both_swabcovid_date_unknow", "included", "screened", "sequenced", "exclusion", "lci_plus", "orv_plus", "test_orv", "week_number", "length_of_hospital_stay", "orv_plus_sans_rsv", "orv_plus_sans_sars_cov_2", "orv_plus_sans_rsv_sans_sars_cov_2", "test_orv_sans_rsv", "test_orv_sans_rsv_sans_sars_cov_2", "test_orv_sans_sars_cov_2", "tranche_age_def1", "tranche_age_def2", "tranche_age_def3");

                // Write column headers to Excel sheet
                $sheet->fromArray($columnNames, NULL, 'A1');
//                CONCAT(ROUND((COUNT(age) / COUNT(*) * 100), 2),'%') as total_age ,
//                CONCAT(ROUND((COUNT(less_age_months) / COUNT(*) * 100), 2),'%') as total_less_age_months ,
//                CONCAT(ROUND((COUNT(more_age_years) / COUNT(*) * 100), 2),'%') as total_more_age_years ,
//                CONCAT(ROUND((COUNT(fever_adm) / COUNT(*) * 100), 2),'%') as total_fever_adm,
//                CONCAT(ROUND((COUNT(less_othersymptoms_malaise) / COUNT(*) * 100), 2),'%') as total_less_othersymptoms_malaise ,
//                CONCAT(ROUND((COUNT(less_othersymptoms_headache) / COUNT(*) * 100), 2),'%') as total_less_othersymptoms_headache ,
//                CONCAT(ROUND((COUNT(less_othersymptoms_myalgia) / COUNT(*) * 100), 2),'%') as total_less_othersymptoms_myalgia ,
//                CONCAT(ROUND((COUNT(less_othersymptoms_cough) / COUNT(*) * 100), 2),'%') as total_less_othersymptoms_cough ,
//                CONCAT(ROUND((COUNT(less_othersymptoms_sorethroat) / COUNT(*) * 100), 2),'%') as total_less_othersymptoms_sorethroat ,
//                CONCAT(ROUND((COUNT(less_othersymptoms_shortnessofbreath) / COUNT(*) * 100), 2),'%') as total_less_othersymptoms_shortnessofbreath ,
//                CONCAT(ROUND((COUNT(less_othersymptoms_nasalcongestion) / COUNT(*) * 100), 2),'%') as total_less_othersymptoms_nasalcongestion  ,

                // Retrieve season-specific data from the databas
                $seasonData = $this->conn->fetchAll("SELECT d.site_id,
                CONCAT(ROUND((COUNT(both_id_patient) / COUNT(*) * 100), 2),'%') as total_both_id_patient,
                CONCAT(ROUND((COUNT(both_age) / COUNT(*) * 100), 2),'%') as total_both_age,
                CONCAT(ROUND((COUNT(both_age_unit) / COUNT(*) * 100), 2),'%') as total_both_age_unit,
                CONCAT(ROUND((COUNT(both_doa) / COUNT(*) * 100), 2),'%') as total_both_doa,
                CONCAT(ROUND((COUNT(id_bdd_philippe) / COUNT(*) * 100), 2),'%') as total_id_bdd_philippe,
                CONCAT(ROUND((COUNT(id_site_bdd_philippe) / COUNT(*) * 100), 2),'%') as total_id_site_bdd_philippe,
                CONCAT(ROUND((COUNT(date_last_modified) / COUNT(*) * 100), 2),'%') as total_date_last_modified,
                CONCAT(ROUND((COUNT(id_last_modificator) / COUNT(*) * 100), 2),'%') as total_id_last_modificator,
                CONCAT(ROUND((COUNT(name_last_modificator) / COUNT(*) * 100), 2),'%') as total_name_last_modificator,
                CONCAT(ROUND((COUNT(is_validated) / COUNT(*) * 100), 2),'%') as total_is_validated,
                CONCAT(ROUND((COUNT(OHC_TECH_ID) / COUNT(*) * 100), 2),'%') as total_OHC_TECH_ID,
                CONCAT(ROUND((COUNT(OHC_TECH_IdIntegration) / COUNT(*) * 100), 2),'%') as total_OHC_TECH_IdIntegration,
                CONCAT(ROUND((COUNT(OHC_TECH_SEA_ID) / COUNT(*) * 100), 2),'%') as total_OHC_TECH_SEA_ID,
                CONCAT(ROUND((COUNT(form_type) / COUNT(*) * 100), 2),'%') as total_form_type,
                CONCAT(ROUND((COUNT(both_comp_a_diag) / COUNT(*) * 100), 2),'%') as total_both_comp_a_diag,
                CONCAT(ROUND((COUNT(both_a_diag) / COUNT(*) * 100), 2),'%') as total_both_a_diag,
                CONCAT(ROUND((COUNT(both_a_diag_icd) / COUNT(*) * 100), 2),'%') as total_both_a_diag_icd,
                CONCAT(ROUND((COUNT(both_id_hospital) / COUNT(*) * 100), 2),'%') as total_both_id_hospital,
                CONCAT(ROUND((COUNT(doq) / COUNT(*) * 100), 2),'%') as total_doq,
                CONCAT(ROUND((COUNT(both_sex) / COUNT(*) * 100), 2),'%') as total_both_sex,
                CONCAT(ROUND((COUNT(dob) / COUNT(*) * 100), 2),'%') as total_dob,
                CONCAT(ROUND((COUNT(communication) / COUNT(*) * 100), 2),'%') as total_communication,
                CONCAT(ROUND((COUNT(consents) / COUNT(*) * 100), 2),'%') as total_consents,
                CONCAT(ROUND((COUNT(residence) / COUNT(*) * 100), 2),'%') as total_residence,
                CONCAT(ROUND((COUNT(institutionalized) / COUNT(*) * 100), 2),'%') as total_institutionalized,
                CONCAT(ROUND((COUNT(exclussion_hosp) / COUNT(*) * 100), 2),'%') as total_exclussion_hosp,
                CONCAT(ROUND((COUNT(soc_class) / COUNT(*) * 100), 2),'%') as total_soc_class,
                CONCAT(ROUND((COUNT(smoking_hab) / COUNT(*) * 100), 2),'%') as total_smoking_hab,
                CONCAT(ROUND((COUNT(both_chronic_cond_yn) / COUNT(*) * 100), 2),'%') as total_both_chronic_cond_yn,
                CONCAT(ROUND((COUNT(both_display_clinical3) / COUNT(*) * 100), 2),'%') as total_both_display_clinical3,
                CONCAT(ROUND((COUNT(both_chronic_cvd_blood) / COUNT(*) * 100), 2),'%') as total_both_chronic_cvd_blood,
                CONCAT(ROUND((COUNT(both_chronic_copd) / COUNT(*) * 100), 2),'%') as total_both_chronic_copd,
                CONCAT(ROUND((COUNT(both_chronic_asthma) / COUNT(*) * 100), 2),'%') as total_both_chronic_asthma,
                CONCAT(ROUND((COUNT(both_chronic_diabetes) / COUNT(*) * 100), 2),'%') as total_both_chronic_diabetes,
                CONCAT(ROUND((COUNT(both_chronic_immuno) / COUNT(*) * 100), 2),'%') as total_both_chronic_immuno,
                CONCAT(ROUND((COUNT(both_chronic_renal) / COUNT(*) * 100), 2),'%') as total_both_chronic_renal,
                CONCAT(ROUND((COUNT(both_chronic_rheumatologic_autoimmune_dis) / COUNT(*) * 100), 2),'%') as total_both_chronic_rheumatologic_autoimmune_dis,
                CONCAT(ROUND((COUNT(both_chronic_neurological_neuromuscular_dis) / COUNT(*) * 100), 2),'%') as total_both_chronic_neurological_neuromuscular_dis,
                CONCAT(ROUND((COUNT(both_chronic_cirrhosis_liver_dis) / COUNT(*) * 100), 2),'%') as total_both_chronic_cirrhosis_liver_dis,
                CONCAT(ROUND((COUNT(both_chronic_neoplasm) / COUNT(*) * 100), 2),'%') as total_both_chronic_neoplasm,
                CONCAT(ROUND((COUNT(both_chronic_obesity) / COUNT(*) * 100), 2),'%') as total_both_chronic_obesity,
                CONCAT(ROUND((COUNT(both_chronic_malnutri) / COUNT(*) * 100), 2),'%') as total_both_chronic_malnutri,
                CONCAT(ROUND((COUNT(both_chronic_active_tuberculosis) / COUNT(*) * 100), 2),'%') as total_both_chronic_active_tuberculosis,
                CONCAT(ROUND((COUNT(both_chronic_hiv_infection) / COUNT(*) * 100), 2),'%') as total_both_chronic_hiv_infection,
                CONCAT(ROUND((COUNT(both_chronic_hiv_exposure) / COUNT(*) * 100), 2),'%') as total_both_chronic_hiv_exposure,
                CONCAT(ROUND((COUNT(both_chronic_other) / COUNT(*) * 100), 2),'%') as total_both_chronic_other,
                CONCAT(ROUND((COUNT(hosp_12m) / COUNT(*) * 100), 2),'%') as total_hosp_12m,
                CONCAT(ROUND((COUNT(av_current_days) / COUNT(*) * 100), 2),'%') as total_av_current_days,
                CONCAT(ROUND((COUNT(both_av_current) / COUNT(*) * 100), 2),'%') as total_both_av_current,
                CONCAT(ROUND((COUNT(both_av_starting_date) / COUNT(*) * 100), 2),'%') as total_both_av_starting_date,
                CONCAT(ROUND((COUNT(previous_lab) / COUNT(*) * 100), 2),'%') as total_previous_lab,
                CONCAT(ROUND((COUNT(both_influ_vac_current_season) / COUNT(*) * 100), 2),'%') as total_both_influ_vac_current_season,
                CONCAT(ROUND((COUNT(both_vac_14d_before_ili_sym) / COUNT(*) * 100), 2),'%') as total_both_vac_14d_before_ili_sym,
                CONCAT(ROUND((COUNT(dov) / COUNT(*) * 100), 2),'%') as total_dov,
                CONCAT(ROUND((COUNT(vac_name) / COUNT(*) * 100), 2),'%') as total_vac_name,
                CONCAT(ROUND((COUNT(vac_type) / COUNT(*) * 100), 2),'%') as total_vac_type,
                CONCAT(ROUND((COUNT(both_vac_preceding_season) / COUNT(*) * 100), 2),'%') as total_both_vac_preceding_season,
                CONCAT(ROUND((COUNT(both_swab_date) / COUNT(*) * 100), 2),'%') as total_both_swab_date,
                CONCAT(ROUND((COUNT(both_swab_date_unknow) / COUNT(*) * 100), 2),'%') as total_both_swab_date_unknow,
                CONCAT(ROUND((COUNT(swab_sent) / COUNT(*) * 100), 2),'%') as total_swab_sent,
                CONCAT(ROUND((COUNT(swab_np) / COUNT(*) * 100), 2),'%') as total_swab_np,
                CONCAT(ROUND((COUNT(swab_n) / COUNT(*) * 100), 2),'%') as total_swab_n,
                CONCAT(ROUND((COUNT(swab_p) / COUNT(*) * 100), 2),'%') as total_swab_p,
                CONCAT(ROUND((COUNT(dol) / COUNT(*) * 100), 2),'%') as total_dol,
                CONCAT(ROUND((COUNT(hypoxia_adm) / COUNT(*) * 100), 2),'%') as total_hypoxia_adm,
                CONCAT(ROUND((COUNT(lethargy_adm) / COUNT(*) * 100), 2),'%') as total_lethargy_adm,
                CONCAT(ROUND((COUNT(both_severity_oxygen_saturation) / COUNT(*) * 100), 2),'%') as total_both_severity_oxygen_saturation,
                CONCAT(ROUND((COUNT(both_severity_oxygen_saturation_unknow) / COUNT(*) * 100), 2),'%') as total_both_severity_oxygen_saturation_unknow,
                CONCAT(ROUND((COUNT(both_severity_respiration_rate) / COUNT(*) * 100), 2),'%') as total_both_severity_respiration_rate,
                CONCAT(ROUND((COUNT(both_severity_respiration_rate_unknow) / COUNT(*) * 100), 2),'%') as total_both_severity_respiration_rate_unknow,
                CONCAT(ROUND((COUNT(blood_urea_nitrogen) / COUNT(*) * 100), 2),'%') as total_blood_urea_nitrogen,
                CONCAT(ROUND((COUNT(both_severity_supp_oxygen) / COUNT(*) * 100), 2),'%') as total_both_severity_supp_oxygen,
                CONCAT(ROUND((COUNT(both_severity_vaso_support) / COUNT(*) * 100), 2),'%') as total_both_severity_vaso_support,
                CONCAT(ROUND((COUNT(both_icu_adm) / COUNT(*) * 100), 2),'%') as total_both_icu_adm,
                CONCAT(ROUND((COUNT(both_death_hosp) / COUNT(*) * 100), 2),'%') as total_both_death_hosp,
                CONCAT(ROUND((COUNT(both_severity_mech_vent) / COUNT(*) * 100), 2),'%') as total_both_severity_mech_vent,
                CONCAT(ROUND((COUNT(both_discharged_date) / COUNT(*) * 100), 2),'%') as total_both_discharged_date,
                CONCAT(ROUND((COUNT(both_d_diag1) / COUNT(*) * 100), 2),'%') as total_both_d_diag1,
                CONCAT(ROUND((COUNT(both_d_diag2) / COUNT(*) * 100), 2),'%') as total_both_d_diag2,
                CONCAT(ROUND((COUNT(both_d_diag3) / COUNT(*) * 100), 2),'%') as total_both_d_diag3,
                CONCAT(ROUND((COUNT(both_d_icd) / COUNT(*) * 100), 2),'%') as total_both_d_icd,
                CONCAT(ROUND((COUNT(both_positive_result) / COUNT(*) * 100), 2),'%') as total_both_positive_result,
                CONCAT(ROUND((COUNT(both_display_labo2) / COUNT(*) * 100), 2),'%') as total_both_display_labo2,
                CONCAT(ROUND((COUNT(both_lab_flu_h1n1) / COUNT(*) * 100), 2),'%') as total_both_lab_flu_h1n1,
                CONCAT(ROUND((COUNT(both_lab_flu_h3n2) / COUNT(*) * 100), 2),'%') as total_both_lab_flu_h3n2,
                CONCAT(ROUND((COUNT(both_lab_flu_yamagata) / COUNT(*) * 100), 2),'%') as total_both_lab_flu_yamagata,
                CONCAT(ROUND((COUNT(both_lab_flu_victoria) / COUNT(*) * 100), 2),'%') as total_both_lab_flu_victoria,
                CONCAT(ROUND((COUNT(both_lab_flu_h1nother) / COUNT(*) * 100), 2),'%') as total_both_lab_flu_h1nother,
                CONCAT(ROUND((COUNT(both_lab_flu_h3nother) / COUNT(*) * 100), 2),'%') as total_both_lab_flu_h3nother,
                CONCAT(ROUND((COUNT(both_lab_flu_a_nosub) / COUNT(*) * 100), 2),'%') as total_both_lab_flu_a_nosub,
                CONCAT(ROUND((COUNT(both_lab_flu_b_nosub) / COUNT(*) * 100), 2),'%') as total_both_lab_flu_b_nosub,
                CONCAT(ROUND((COUNT(both_lab2_corona_yesno) / COUNT(*) * 100), 2),'%') as total_both_lab2_corona_yesno,
                CONCAT(ROUND((COUNT(both_lab2_metaneumo_yesno) / COUNT(*) * 100), 2),'%') as total_both_lab2_metaneumo_yesno,
                CONCAT(ROUND((COUNT(both_lab2_rs_yesno) / COUNT(*) * 100), 2),'%') as total_both_lab2_rs_yesno,
                CONCAT(ROUND((COUNT(both_lab2_adeno_yesno) / COUNT(*) * 100), 2),'%') as total_both_lab2_adeno_yesno,
                CONCAT(ROUND((COUNT(both_lab2_boca_yesno) / COUNT(*) * 100), 2),'%') as total_both_lab2_boca_yesno,
                CONCAT(ROUND((COUNT(both_lab2_pi_yesno) / COUNT(*) * 100), 2),'%') as total_both_lab2_pi_yesno,
                CONCAT(ROUND((COUNT(both_lab2_rhino_yesno) / COUNT(*) * 100), 2),'%') as total_both_lab2_rhino_yesno,
                CONCAT(ROUND((COUNT(lab_mix) / COUNT(*) * 100), 2),'%') as total_lab_mix,
                CONCAT(ROUND((COUNT(both_detected_coinfection) / COUNT(*) * 100), 2),'%') as total_both_detected_coinfection,
                CONCAT(ROUND((COUNT(lab_negative) / COUNT(*) * 100), 2),'%') as total_lab_negative,
                CONCAT(ROUND((COUNT(sym_7d_yn) / COUNT(*) * 100), 2),'%') as total_sym_7d_yn,
                CONCAT(ROUND((COUNT(both_display_ilisystemic) / COUNT(*) * 100), 2),'%') as total_both_display_ilisystemic,
                CONCAT(ROUND((COUNT(both_ilisystemic_fever) / COUNT(*) * 100), 2),'%') as total_both_ilisystemic_fever,
                CONCAT(ROUND((COUNT(both_ilisystemic_malaise) / COUNT(*) * 100), 2),'%') as total_both_ilisystemic_malaise,
                CONCAT(ROUND((COUNT(both_ilisystemic_headache) / COUNT(*) * 100), 2),'%') as total_both_ilisystemic_headache,
                CONCAT(ROUND((COUNT(both_ilisystemic_myalgia) / COUNT(*) * 100), 2),'%') as total_both_ilisystemic_myalgia,
                CONCAT(ROUND((COUNT(both_ilirespiratory_cough) / COUNT(*) * 100), 2),'%') as total_both_ilirespiratory_cough,
                CONCAT(ROUND((COUNT(both_ilirespiratory_sorethroat) / COUNT(*) * 100), 2),'%') as total_both_ilirespiratory_sorethroat,
                CONCAT(ROUND((COUNT(both_ilirespiratory_shortnessbreath) / COUNT(*) * 100), 2),'%') as total_both_ilirespiratory_shortnessbreath,
                CONCAT(ROUND((COUNT(both_display_ilirespiratory) / COUNT(*) * 100), 2),'%') as total_both_display_ilirespiratory,
                CONCAT(ROUND((COUNT(both_ilirespiratory_nasalcongestion) / COUNT(*) * 100), 2),'%') as total_both_ilirespiratory_nasalcongestion,
                CONCAT(ROUND((COUNT(doo) / COUNT(*) * 100), 2),'%') as total_doo,
                CONCAT(ROUND((COUNT(both_epi_isl) / COUNT(*) * 100), 2),'%') as total_both_epi_isl,
                CONCAT(ROUND((COUNT(both_display_clinical2) / COUNT(*) * 100), 2),'%') as total_both_display_clinical2,
                CONCAT(ROUND((COUNT(both_display_clinical4) / COUNT(*) * 100), 2),'%') as total_both_display_clinical4,
                CONCAT(ROUND((COUNT(both_display_clinical5) / COUNT(*) * 100), 2),'%') as total_both_display_clinical5,
                CONCAT(ROUND((COUNT(both_display_clinical6) / COUNT(*) * 100), 2),'%') as total_both_display_clinical6,
                CONCAT(ROUND((COUNT(both_display_clinical7) / COUNT(*) * 100), 2),'%') as total_both_display_clinical7,
                CONCAT(ROUND((COUNT(both_pregnancy_status) / COUNT(*) * 100), 2),'%') as total_both_pregnancy_status,
                CONCAT(ROUND((COUNT(both_pregnancy_weeks) / COUNT(*) * 100), 2),'%') as total_both_pregnancy_weeks,
                CONCAT(ROUND((COUNT(both_pregnancy_weeks_unknow) / COUNT(*) * 100), 2),'%') as total_both_pregnancy_weeks_unknow,
                CONCAT(ROUND((COUNT(both_display_hasonesymptoms) / COUNT(*) * 100), 2),'%') as total_both_display_hasonesymptoms,
                CONCAT(ROUND((COUNT(comp_ili) / COUNT(*) * 100), 2),'%') as total_comp_ili,
                CONCAT(ROUND((COUNT(comp_ili_7d) / COUNT(*) * 100), 2),'%') as total_comp_ili_7d,
                CONCAT(ROUND((COUNT(more_comply) / COUNT(*) * 100), 2),'%') as total_more_comply,
                CONCAT(ROUND((COUNT(both_test_other_virus) / COUNT(*) * 100), 2),'%') as total_both_test_other_virus,
                CONCAT(ROUND((COUNT(both_display_test_other2) / COUNT(*) * 100), 2),'%') as total_both_display_test_other2,
                CONCAT(ROUND((COUNT(display_titre_labo) / COUNT(*) * 100), 2),'%') as total_display_titre_labo,
                CONCAT(ROUND((COUNT(both_height) / COUNT(*) * 100), 2),'%') as total_both_height,
                CONCAT(ROUND((COUNT(both_weight) / COUNT(*) * 100), 2),'%') as total_both_weight,
                CONCAT(ROUND((COUNT(both_height_unknow) / COUNT(*) * 100), 2),'%') as total_both_height_unknow,
                CONCAT(ROUND((COUNT(both_weight_unknow) / COUNT(*) * 100), 2),'%') as total_both_weight_unknow,
                CONCAT(ROUND((COUNT(birthweight) / COUNT(*) * 100), 2),'%') as total_birthweight,
                CONCAT(ROUND((COUNT(gestbirth_wk_yn) / COUNT(*) * 100), 2),'%') as total_gestbirth_wk_yn,
                CONCAT(ROUND((COUNT(gestbirth_wk) / COUNT(*) * 100), 2),'%') as total_gestbirth_wk,
                CONCAT(ROUND((COUNT(exclu_breast_fed) / COUNT(*) * 100), 2),'%') as total_exclu_breast_fed,
                CONCAT(ROUND((COUNT(breastfed_yn) / COUNT(*) * 100), 2),'%') as total_breastfed_yn,
                CONCAT(ROUND((COUNT(breastfed_month_time) / COUNT(*) * 100), 2),'%') as total_breastfed_month_time,
                CONCAT(ROUND((COUNT(temperature_adm) / COUNT(*) * 100), 2),'%') as total_temperature_adm,
                CONCAT(ROUND((COUNT(both_chronic_prematurity) / COUNT(*) * 100), 2),'%') as total_both_chronic_prematurity,
                CONCAT(ROUND((COUNT(less_chronic_down_syndrom) / COUNT(*) * 100), 2),'%') as total_less_chronic_down_syndrom,
                CONCAT(ROUND((COUNT(less_chronic_congenital_heart_dis) / COUNT(*) * 100), 2),'%') as total_less_chronic_congenital_heart_dis,
                CONCAT(ROUND((COUNT(more_chronic_leukemia) / COUNT(*) * 100), 2),'%') as total_more_chronic_leukemia,
                CONCAT(ROUND((COUNT(both_chronic_hemoglobinopathies) / COUNT(*) * 100), 2),'%') as total_both_chronic_hemoglobinopathies,
                CONCAT(ROUND((COUNT(both_antibio_preceding) / COUNT(*) * 100), 2),'%') as total_both_antibio_preceding,
                CONCAT(ROUND((COUNT(both_antibio_preceding_date) / COUNT(*) * 100), 2),'%') as total_both_antibio_preceding_date,
                CONCAT(ROUND((COUNT(both_frailty_score) / COUNT(*) * 100), 2),'%') as total_both_frailty_score,
                CONCAT(ROUND((COUNT(both_frailty_score_unknow) / COUNT(*) * 100), 2),'%') as total_both_frailty_score_unknow,
                CONCAT(ROUND((COUNT(less_influ_vac_current_season_2_doses) / COUNT(*) * 100), 2),'%') as total_less_influ_vac_current_season_2_doses,
                CONCAT(ROUND((COUNT(barthel_index) / COUNT(*) * 100), 2),'%') as total_barthel_index,
                CONCAT(ROUND((COUNT(both_severity_confusion) / COUNT(*) * 100), 2),'%') as total_both_severity_confusion,
                CONCAT(ROUND((COUNT(both_severity_apnea) / COUNT(*) * 100), 2),'%') as total_both_severity_apnea,
                CONCAT(ROUND((COUNT(both_discharge_another_hopital) / COUNT(*) * 100), 2),'%') as total_both_discharge_another_hopital,
                CONCAT(ROUND((COUNT(both_frailty_score_discharge) / COUNT(*) * 100), 2),'%') as total_both_frailty_score_discharge,
                CONCAT(ROUND((COUNT(both_frailty_score_discharge_unknow) / COUNT(*) * 100), 2),'%') as total_both_frailty_score_discharge_unknow,
                CONCAT(ROUND((COUNT(both_sample_submited) / COUNT(*) * 100), 2),'%') as total_both_sample_submited,
                CONCAT(ROUND((COUNT(both_display_gisaid) / COUNT(*) * 100), 2),'%') as total_both_display_gisaid,
                CONCAT(ROUND((COUNT(less_display_intro) / COUNT(*) * 100), 2),'%') as total_less_display_intro,
                CONCAT(ROUND((COUNT(more_display_intro) / COUNT(*) * 100), 2),'%') as total_more_display_intro,
                CONCAT(ROUND((COUNT(SysStartTime) / COUNT(*) * 100), 2),'%') as total_SysStartTime,
                CONCAT(ROUND((COUNT(SysEndTime) / COUNT(*) * 100), 2),'%') as total_SysEndTime,
                CONCAT(ROUND((COUNT(OHC_CleSignature) / COUNT(*) * 100), 2),'%') as total_OHC_CleSignature,
                CONCAT(ROUND((COUNT(OHC_Signature) / COUNT(*) * 100), 2),'%') as total_OHC_Signature,
                CONCAT(ROUND((COUNT(both_display_clinical6b) / COUNT(*) * 100), 2),'%') as total_both_display_clinical6b,
                CONCAT(ROUND((COUNT(both_lab2_corona) / COUNT(*) * 100), 2),'%') as total_both_lab2_corona,
                CONCAT(ROUND((COUNT(both_lab2_metaneumo) / COUNT(*) * 100), 2),'%') as total_both_lab2_metaneumo,
                CONCAT(ROUND((COUNT(both_lab2_rs) / COUNT(*) * 100), 2),'%') as total_both_lab2_rs,
                CONCAT(ROUND((COUNT(both_lab2_adeno) / COUNT(*) * 100), 2),'%') as total_both_lab2_adeno,
                CONCAT(ROUND((COUNT(both_lab2_boca) / COUNT(*) * 100), 2),'%') as total_both_lab2_boca,
                CONCAT(ROUND((COUNT(both_lab2_pi) / COUNT(*) * 100), 2),'%') as total_both_lab2_pi,
                CONCAT(ROUND((COUNT(both_lab2_rhino) / COUNT(*) * 100), 2),'%') as total_both_lab2_rhino,
                CONCAT(ROUND((COUNT(both_display_hasothersymptoms) / COUNT(*) * 100), 2),'%') as total_both_display_hasothersymptoms,
                CONCAT(ROUND((COUNT(both_othersymptoms_nausea) / COUNT(*) * 100), 2),'%') as total_both_othersymptoms_nausea,
                CONCAT(ROUND((COUNT(both_othersymptoms_diarrhea) / COUNT(*) * 100), 2),'%') as total_both_othersymptoms_diarrhea,
                CONCAT(ROUND((COUNT(both_othersymptoms_smell) / COUNT(*) * 100), 2),'%') as total_both_othersymptoms_smell,
                CONCAT(ROUND((COUNT(both_othersymptoms_chestpain) / COUNT(*) * 100), 2),'%') as total_both_othersymptoms_chestpain,
                CONCAT(ROUND((COUNT(both_ilirespiratory_wheezing) / COUNT(*) * 100), 2),'%') as total_both_ilirespiratory_wheezing,
                CONCAT(ROUND((COUNT(both_antibio_during) / COUNT(*) * 100), 2),'%') as total_both_antibio_during,
                CONCAT(ROUND((COUNT(both_antibio_during_date) / COUNT(*) * 100), 2),'%') as total_both_antibio_during_date,
                CONCAT(ROUND((COUNT(both_antiviral_preceding) / COUNT(*) * 100), 2),'%') as total_both_antiviral_preceding,
                CONCAT(ROUND((COUNT(both_antiviral_preceding_date) / COUNT(*) * 100), 2),'%') as total_both_antiviral_preceding_date,
                CONCAT(ROUND((COUNT(both_antiviral_during) / COUNT(*) * 100), 2),'%') as total_both_antiviral_during,
                CONCAT(ROUND((COUNT(both_antiviral_during_date) / COUNT(*) * 100), 2),'%') as total_both_antiviral_during_date,
                CONCAT(ROUND((COUNT(both_vac_history_validated) / COUNT(*) * 100), 2),'%') as total_both_vac_history_validated,
                CONCAT(ROUND((COUNT(more_display_comment) / COUNT(*) * 100), 2),'%') as total_more_display_comment,
                CONCAT(ROUND((COUNT(less_display_comment) / COUNT(*) * 100), 2),'%') as total_less_display_comment,
                CONCAT(ROUND((COUNT(both_lab2_sarscov2) / COUNT(*) * 100), 2),'%') as total_both_lab2_sarscov2,
                CONCAT(ROUND((COUNT(both_lab2_sarscov2_yesno) / COUNT(*) * 100), 2),'%') as total_both_lab2_sarscov2_yesno,
                CONCAT(ROUND((COUNT(both_lab2_evd68) / COUNT(*) * 100), 2),'%') as total_both_lab2_evd68,
                CONCAT(ROUND((COUNT(both_lab2_evd68_yesno) / COUNT(*) * 100), 2),'%') as total_both_lab2_evd68_yesno,
                CONCAT(ROUND((COUNT(both_lab2_others) / COUNT(*) * 100), 2),'%') as total_both_lab2_others,
                CONCAT(ROUND((COUNT(both_lab2_others_yesno) / COUNT(*) * 100), 2),'%') as total_both_lab2_others_yesno,
                CONCAT(ROUND((COUNT(more_covid_firstdose) / COUNT(*) * 100), 2),'%') as total_more_covid_firstdose,
                CONCAT(ROUND((COUNT(more_covid_full) / COUNT(*) * 100), 2),'%') as total_more_covid_full,
                CONCAT(ROUND((COUNT(more_covid_vaccine) / COUNT(*) * 100), 2),'%') as total_more_covid_vaccine,
                CONCAT(ROUND((COUNT(flu_vac_2010_11) / COUNT(*) * 100), 2),'%') as total_flu_vac_2010_11,
                CONCAT(ROUND((COUNT(flu_vac_2011_12) / COUNT(*) * 100), 2),'%') as total_flu_vac_2011_12,
                CONCAT(ROUND((COUNT(flu_vac_2012_13) / COUNT(*) * 100), 2),'%') as total_flu_vac_2012_13,
                CONCAT(ROUND((COUNT(flu_vac_2013_14) / COUNT(*) * 100), 2),'%') as total_flu_vac_2013_14,
                CONCAT(ROUND((COUNT(flu_vac_2014_15) / COUNT(*) * 100), 2),'%') as total_flu_vac_2014_15,
                CONCAT(ROUND((COUNT(flu_vac_2015_16) / COUNT(*) * 100), 2),'%') as total_flu_vac_2015_16,
                CONCAT(ROUND((COUNT(flu_vac_2016_17) / COUNT(*) * 100), 2),'%') as total_flu_vac_2016_17,
                CONCAT(ROUND((COUNT(flu_vac_2017_18) / COUNT(*) * 100), 2),'%') as total_flu_vac_2017_18,
                CONCAT(ROUND((COUNT(flu_vac_2018_19) / COUNT(*) * 100), 2),'%') as total_flu_vac_2018_19,
                CONCAT(ROUND((COUNT(flu_vac_2019_20) / COUNT(*) * 100), 2),'%') as total_flu_vac_2019_20,
                CONCAT(ROUND((COUNT(flu_vac_2020_21) / COUNT(*) * 100), 2),'%') as total_flu_vac_2020_21,
                CONCAT(ROUND((COUNT(flu_vac_2021_22) / COUNT(*) * 100), 2),'%') as total_flu_vac_2021_22,
                CONCAT(ROUND((COUNT(flu_vac_2022_23) / COUNT(*) * 100), 2),'%') as total_flu_vac_2022_23,
                CONCAT(ROUND((COUNT(flu_vac_2023_24) / COUNT(*) * 100), 2),'%') as total_flu_vac_2023_24,
                CONCAT(ROUND((COUNT(flu_vac_2024_25) / COUNT(*) * 100), 2),'%') as total_flu_vac_2024_25,
                CONCAT(ROUND((COUNT(flu_vac_2026_27) / COUNT(*) * 100), 2),'%') as total_flu_vac_2026_27,
                CONCAT(ROUND((COUNT(ecmo) / COUNT(*) * 100), 2),'%') as total_ecmo,
                CONCAT(ROUND((COUNT(reason_no_com) / COUNT(*) * 100), 2),'%') as total_reason_no_com,
                CONCAT(ROUND((COUNT(consul_3m) / COUNT(*) * 100), 2),'%') as total_consul_3m,
                CONCAT(ROUND((COUNT(contra_flu) / COUNT(*) * 100), 2),'%') as total_contra_flu,
                CONCAT(ROUND((COUNT(sudden) / COUNT(*) * 100), 2),'%') as total_sudden,
                CONCAT(ROUND((COUNT(polypnea) / COUNT(*) * 100), 2),'%') as total_polypnea,
                CONCAT(ROUND((COUNT(both_severity_blood_pressure) / COUNT(*) * 100), 2),'%') as total_both_severity_blood_pressure,
                CONCAT(ROUND((COUNT(both_severity_blood_pressure_unknow) / COUNT(*) * 100), 2),'%') as total_both_severity_blood_pressure_unknow,
                CONCAT(ROUND((COUNT(both_display_intro) / COUNT(*) * 100), 2),'%') as total_both_display_intro,
                CONCAT(ROUND((COUNT(both_display_how_patient_was_identified) / COUNT(*) * 100), 2),'%') as total_both_display_how_patient_was_identified,
                CONCAT(ROUND((COUNT(both_a_diag_unknow) / COUNT(*) * 100), 2),'%') as total_both_a_diag_unknow,
                CONCAT(ROUND((COUNT(both_case_identified_based_logs_respiratory) / COUNT(*) * 100), 2),'%') as total_both_case_identified_based_logs_respiratory,
                CONCAT(ROUND((COUNT(both_case_identified_based_testing) / COUNT(*) * 100), 2),'%') as total_both_case_identified_based_testing,
                CONCAT(ROUND((COUNT(both_case_definition_used) / COUNT(*) * 100), 2),'%') as total_both_case_definition_used,
                CONCAT(ROUND((COUNT(both_case_definition_other_detail) / COUNT(*) * 100), 2),'%') as total_both_case_definition_other_detail,
                CONCAT(ROUND((COUNT(both_lab2_others_detail) / COUNT(*) * 100), 2),'%') as total_both_lab2_others_detail,
                CONCAT(ROUND((COUNT(both_antiviral_preceding_date_unknow) / COUNT(*) * 100), 2),'%') as total_both_antiviral_preceding_date_unknow,
                CONCAT(ROUND((COUNT(both_antiviral_during_date_unknow) / COUNT(*) * 100), 2),'%') as total_both_antiviral_during_date_unknow,
                CONCAT(ROUND((COUNT(both_antibio_preceding_date_unknow) / COUNT(*) * 100), 2),'%') as total_both_antibio_preceding_date_unknow,
                CONCAT(ROUND((COUNT(both_antibio_during_date_unknow) / COUNT(*) * 100), 2),'%') as total_both_antibio_during_date_unknow,
                CONCAT(ROUND((COUNT(both_vac_type_vaccine) / COUNT(*) * 100), 2),'%') as total_both_vac_type_vaccine,
                CONCAT(ROUND((COUNT(both_display_clinical5bis) / COUNT(*) * 100), 2),'%') as total_both_display_clinical5bis,
                CONCAT(ROUND((COUNT(both_covid_number_doses) / COUNT(*) * 100), 2),'%') as total_both_covid_number_doses,
                CONCAT(ROUND((COUNT(both_covid_last_dose_date) / COUNT(*) * 100), 2),'%') as total_both_covid_last_dose_date,
                CONCAT(ROUND((COUNT(both_swabcovid_date) / COUNT(*) * 100), 2),'%') as total_both_swabcovid_date,
                CONCAT(ROUND((COUNT(both_covid_last_dose_date_unknow) / COUNT(*) * 100), 2),'%') as total_both_covid_last_dose_date_unknow,
                CONCAT(ROUND((COUNT(both_display_covid_vaccine) / COUNT(*) * 100), 2),'%') as total_both_display_covid_vaccine,
                CONCAT(ROUND((COUNT(both_covid_vaccine_mrna) / COUNT(*) * 100), 2),'%') as total_both_covid_vaccine_mrna,
                CONCAT(ROUND((COUNT(both_covid_vaccine_inactivated_virion) / COUNT(*) * 100), 2),'%') as total_both_covid_vaccine_inactivated_virion,
                CONCAT(ROUND((COUNT(both_covid_vaccine_viral_vector) / COUNT(*) * 100), 2),'%') as total_both_covid_vaccine_viral_vector,
                CONCAT(ROUND((COUNT(both_covid_vaccine_protein_subunit) / COUNT(*) * 100), 2),'%') as total_both_covid_vaccine_protein_subunit,
                CONCAT(ROUND((COUNT(both_covid_vaccine_unknow) / COUNT(*) * 100), 2),'%') as total_both_covid_vaccine_unknow,
                CONCAT(ROUND((COUNT(both_severity_high_dependence_unit) / COUNT(*) * 100), 2),'%') as total_both_severity_high_dependence_unit,
                CONCAT(ROUND((COUNT(both_d_diag1_unknow) / COUNT(*) * 100), 2),'%') as total_both_d_diag1_unknow,
                CONCAT(ROUND((COUNT(both_d_diag2_unknow) / COUNT(*) * 100), 2),'%') as total_both_d_diag2_unknow,
                CONCAT(ROUND((COUNT(both_d_diag3_unknow) / COUNT(*) * 100), 2),'%') as total_both_d_diag3_unknow,
                CONCAT(ROUND((COUNT(both_sample_type) / COUNT(*) * 100), 2),'%') as total_both_sample_type,
                CONCAT(ROUND((COUNT(both_swabcovid_date_unknow) / COUNT(*) * 100), 2),'%') as total_both_swabcovid_date_unknow,
                CONCAT(ROUND((COUNT(included) / COUNT(*) * 100), 2),'%') as total_included,
                CONCAT(ROUND((COUNT(screened) / COUNT(*) * 100), 2),'%') as total_screened,
                CONCAT(ROUND((COUNT(sequenced) / COUNT(*) * 100), 2),'%') as total_sequenced,
                CONCAT(ROUND((COUNT(exclusion) / COUNT(*) * 100), 2),'%') as total_exclusion,
                CONCAT(ROUND((COUNT(lci_plus) / COUNT(*) * 100), 2),'%') as total_lci_plus,
                CONCAT(ROUND((COUNT(orv_plus) / COUNT(*) * 100), 2),'%') as total_orv_plus,
                CONCAT(ROUND((COUNT(test_orv) / COUNT(*) * 100), 2),'%') as total_test_orv,
                CONCAT(ROUND((COUNT(week_number) / COUNT(*) * 100), 2),'%') as total_week_number,
                CONCAT(ROUND((COUNT(length_of_hospital_stay) / COUNT(*) * 100), 2),'%') as total_length_of_hospital_stay,
                CONCAT(ROUND((COUNT(orv_plus_sans_rsv) / COUNT(*) * 100), 2),'%') as total_orv_plus_sans_rsv,
                CONCAT(ROUND((COUNT(orv_plus_sans_sars_cov_2) / COUNT(*) * 100), 2),'%') as total_orv_plus_sans_sars_cov_2,
                CONCAT(ROUND((COUNT(orv_plus_sans_rsv_sans_sars_cov_2) / COUNT(*) * 100), 2),'%') as total_orv_plus_sans_rsv_sans_sars_cov_2,
                CONCAT(ROUND((COUNT(test_orv_sans_rsv) / COUNT(*) * 100), 2),'%') as total_test_orv_sans_rsv,
                CONCAT(ROUND((COUNT(test_orv_sans_rsv_sans_sars_cov_2) / COUNT(*) * 100), 2),'%') as total_test_orv_sans_rsv_sans_sars_cov_2,
                CONCAT(ROUND((COUNT(test_orv_sans_sars_cov_2) / COUNT(*) * 100), 2),'%') as total_test_orv_sans_sars_cov_2,
                CONCAT(ROUND((COUNT(tranche_age_def1) / COUNT(*) * 100), 2),'%') as total_tranche_age_def1,
                CONCAT(ROUND((COUNT(tranche_age_def2) / COUNT(*) * 100), 2),'%') as total_tranche_age_def2,
                CONCAT(ROUND((COUNT(tranche_age_def3) / COUNT(*) * 100), 2),'%') as total_tranche_age_def3,
                CONCAT(ROUND((COUNT(both_sample_submited_influenza) / COUNT(*) * 100), 2),'%') as total_both_sample_submited_influenza,
                CONCAT(ROUND((COUNT(both_epi_isl_influenza) / COUNT(*) * 100), 2),'%') as total_both_epi_isl_influenza,
                CONCAT(ROUND((COUNT(both_sample_submited_sars_cov2) / COUNT(*) * 100), 2),'%') as total_both_sample_submited_sars_cov2,
                CONCAT(ROUND((COUNT(both_epi_isl_sars_cov2) / COUNT(*) * 100), 2),'%') as total_both_epi_isl_sars_cov2,
                CONCAT(ROUND((COUNT(both_epi_isl_rsv) / COUNT(*) * 100), 2),'%') as total_both_epi_isl_rsv
                FROM data d
                where d.season = '".$season."'
                GROUP BY d.site_id order by d.site_id");
                $rowIndex = 2;
                // Parcourir les données par site
                foreach ($seasonData as $dataRow) {
                    // calculate the total number of lines per site and per season
//                    $nbrRowPerSite = $this->conn->fetchAll("SELECT * from data WHERE site_id = ".$dataRow['site_id']."
//                     and season ='".$season."'");
                    $columnIndex = 1;
                    foreach ($dataRow as $key=>$value) {
                        // calculate the percentage if the key different from site id
//                        if ($key!=="site_id" ){
////                            $percent = (int)$value / count($nbrRowPerSite) * 100;
//                            // Write values one by one using setCellValueByColumnAndRow
//                            $sheet->setCellValueByColumnAndRow($columnIndex, $rowIndex, number_format($percent, 2).'%');
//                        }else {
                            // Write values one by one using setCellValueByColumnAndRow
                            $sheet->setCellValueByColumnAndRow($columnIndex, $rowIndex, $value);
//                        }
                        $columnIndex++;
                    }
                    $rowIndex++;
                }
            }
            // Delete the first sheet (sheet)
            $spreadsheet->removeSheetByIndex(0);
            // Save Excel file
            $writer = new Xlsx($spreadsheet);
            $writer->save($filexlsx);

            $io->success(date('H:i:s'));
            $io->success('Export terminer');
            $this->emailsTemplateSender->email_send_completeness_database($filename . '.xlsx', $arg1, str_replace("_"," ",$arg2));

            return 0;
        }

        $io->success('erreur id manquant');

        return 0;

    }
}
